/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.factory.gui;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.Slot;

import net.minecraftforge.fluids.Fluid;

import buildcraft.BuildCraftFactory;
import buildcraft.core.lib.gui.BuildCraftContainer;
import buildcraft.core.lib.network.command.CommandWriter;
import buildcraft.core.lib.network.command.PacketCommand;
import buildcraft.factory.TileRefinery;

import io.netty.buffer.ByteBuf;

public class ContainerRefinery extends BuildCraftContainer {
    public TileRefinery refinery;

    public ContainerRefinery(EntityPlayer player, TileRefinery refinery) {
        super(player, 0);

        for (int l = 0; l < 3; l++) {
            for (int k1 = 0; k1 < 9; k1++) {
                func_75146_a(new Slot(player.field_71071_by, k1 + l * 9 + 9, 8 + k1 * 18, 123 + l * 18));
            }
        }

        for (int i1 = 0; i1 < 9; i1++) {
            func_75146_a(new Slot(player.field_71071_by, i1, 8 + i1 * 18, 181));
        }

        this.refinery = refinery;
    }

    @Override
    public boolean func_75145_c(EntityPlayer entityplayer) {
        return entityplayer.field_70170_p.func_175625_s(refinery.func_174877_v()) == refinery;
    }

    /* SETTING AND GETTING FILTERS */
    public void setFilter(final int slot, final Fluid filter) {

        refinery.setFilter(slot, filter);

        if (refinery.func_145831_w().field_72995_K) {
            CommandWriter payload = new CommandWriter() {
                @Override
                public void write(ByteBuf data) {
                    data.writeByte(slot);
                    data.writeShort(filter != null ? filter.getID() : -1);
                }
            };
            BuildCraftFactory.instance.sendToServer(new PacketCommand(refinery, "setFilter", payload));
        }
    }

    public Fluid getFilter(int slot) {
        return refinery.getFilter(slot);
    }

    /* GUI DISPLAY UPDATES */
    @Override
    public void func_75137_b(int i, int j) {
        refinery.getGUINetworkData(i, j);
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();
        for (Object crafter : field_75149_d) {
            refinery.sendGUINetworkData(this, (ICrafting) crafter);
        }
    }
}
