/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.factory.gui;

import org.lwjgl.opengl.GL11;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

import buildcraft.core.lib.gui.GuiBuildCraft;
import buildcraft.core.lib.utils.BCStringUtils;
import buildcraft.factory.TileAutoWorkbench;

public class GuiAutoCrafting extends GuiBuildCraft {

    public static final ResourceLocation TEXTURE = new ResourceLocation("buildcraftfactory:textures/gui/autobench.png");
    private TileAutoWorkbench bench;

    public GuiAutoCrafting(EntityPlayer player, World world, TileAutoWorkbench tile) {
        super(new ContainerAutoWorkbench(player, tile), tile, TEXTURE);
        this.bench = tile;
        field_146999_f = 176;
        field_147000_g = 197;
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        String title = BCStringUtils.localize("tile.autoWorkbenchBlock.name");
        field_146289_q.func_78276_b(title, getCenteredOffset(title), 6, 0x404040);
        field_146289_q.func_78276_b(BCStringUtils.localize("gui.inventory"), 8, (field_147000_g - 96) + 2, 0x404040);
    }

    @Override
    protected void func_146976_a(float f, int mouseX, int mouseY) {
        GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
        field_146297_k.field_71446_o.func_110577_a(TEXTURE);
        func_73729_b(field_147003_i, field_147009_r, 0, 0, field_146999_f, field_147000_g);
        if (bench.progress > 0) {
            int progress = bench.getProgressScaled(23);
            func_73729_b(field_147003_i + 89, field_147009_r + 45, 176, 0, progress + 1, 12);
        }
    }
}
