package buildcraft.factory.gui;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;

import buildcraft.core.lib.gui.GuiAdvancedInterface;
import buildcraft.factory.tile.TileDistiller;

public class GuiDistiller extends GuiAdvancedInterface {

    private static final ResourceLocation TEXTURE = new ResourceLocation("buildcraftfactory:textures/gui/distiller.png");

    private final TileDistiller distiller;
    private int inTicks, outGasTicks, outLiquidTicks, craftTicks;

    public GuiDistiller(EntityPlayer player, TileDistiller distiller) {
        super(new ContainerDistiller(player, distiller), distiller, TEXTURE);
        this.distiller = distiller;
        field_146999_f = 176;
        field_147000_g = 161;
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        inTicks--;
        outGasTicks--;
        outLiquidTicks--;
        craftTicks--;
        boolean crafted = distiller.hasCraftedRecently();
        if (crafted) craftTicks = 20;
        if ((distiller.getInputTank().getFluidAmount() > 0) || crafted) inTicks = 20;
        if ((distiller.getOutputTankGas().getFluidAmount() > 0) || crafted) outGasTicks = 20;
        if ((distiller.getOutputTankLiquid().getFluidAmount() > 0) || crafted) outLiquidTicks = 20;
    }

    @Override
    protected void func_146976_a(float f, int mouseX, int mouseY) {
        field_146297_k.field_71446_o.func_110577_a(TEXTURE);
        func_73729_b(field_147003_i, field_147009_r, 0, 0, field_146999_f, field_147000_g);
        super.func_146976_a(f, mouseX, mouseY);
        if (distiller != null) {

            field_146297_k.field_71446_o.func_110577_a(TEXTURE);

            if (craftTicks > 0) {
                func_73729_b(field_147003_i + 61, field_147009_r + 12, 212, 0, 36, 57);
            } else {
                if (inTicks > 0) {
                    func_73729_b(field_147003_i + 61, field_147009_r + 35, 176, 23, 12, 11);
                }
                if (outGasTicks > 0) {
                    func_73729_b(field_147003_i + 89, field_147009_r + 13, 204, 1, 8, 11);
                }
                if (outLiquidTicks > 0) {
                    func_73729_b(field_147003_i + 89, field_147009_r + 57, 204, 45, 8, 11);
                }
            }
        }
    }
}
