package buildcraft.factory.gui;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;

import buildcraft.core.lib.gui.GuiAdvancedInterface;
import buildcraft.factory.tile.TileHeatExchange;

public class GuiHeatExchanger extends GuiAdvancedInterface {

    private static final ResourceLocation TEXTURE = new ResourceLocation("buildcraftfactory:textures/gui/heat_exchanger.png");

    private final TileHeatExchange heatExchange;
    private int inCoolableTicks, inHeatableTicks, outCooledTicks, outHeatedTicks, craftTicks;

    public GuiHeatExchanger(EntityPlayer player, TileHeatExchange heatExchange) {
        super(new ContainerHeatExchange(player, heatExchange), heatExchange, TEXTURE);
        this.heatExchange = heatExchange;
        field_146999_f = 176;
        field_147000_g = 171;
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        inCoolableTicks--;
        inHeatableTicks--;
        outCooledTicks--;
        outHeatedTicks--;
        craftTicks--;
        boolean crafted = heatExchange.hasCraftedRecently();
        if (crafted) craftTicks = 20;
        if (heatExchange.getInputCoolable().getFluidAmount() > 0 || crafted) inCoolableTicks = 20;
        if (heatExchange.getInputHeatable().getFluidAmount() > 0 || crafted) inHeatableTicks = 20;

        if (heatExchange.getOutputCooled().getFluidAmount() > 0 || crafted) outCooledTicks = 20;
        if (heatExchange.getOutputHeated().getFluidAmount() > 0 || crafted) outHeatedTicks = 20;
    }

    @Override
    protected void func_146976_a(float f, int mouseX, int mouseY) {
        field_146297_k.field_71446_o.func_110577_a(TEXTURE);
        func_73729_b(field_147003_i, field_147009_r, 0, 0, field_146999_f, field_147000_g);
        super.func_146976_a(f, mouseX, mouseY);
        if (heatExchange != null) {
            field_146297_k.field_71446_o.func_110577_a(TEXTURE);

            if (craftTicks > 0) {
                func_73729_b(field_147003_i + 61, field_147009_r + 11, 176, 71, 54, 71);
            } else {
                if (inCoolableTicks > 0) {
                    func_73729_b(field_147003_i + 61, field_147009_r + 41, 176, 30, 11, 11);
                }
                if (inHeatableTicks > 0) {
                    func_73729_b(field_147003_i + 79, field_147009_r + 67, 194, 56, 11, 11);
                }
                if (outCooledTicks > 0) {
                    func_73729_b(field_147003_i + 104, field_147009_r + 41, 219, 30, 11, 11);
                }
                if (outHeatedTicks > 0) {
                    func_73729_b(field_147003_i + 86, field_147009_r + 15, 201, 4, 11, 11);
                }
            }
        }
    }
}
