/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.robotics;

import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

import buildcraft.BuildCraftRobotics;
import buildcraft.core.GuiIds;
import buildcraft.core.lib.block.BlockBuildCraft;
import buildcraft.core.lib.block.IComparatorInventory;

public class BlockRequester extends BlockBuildCraft implements IComparatorInventory {
    public BlockRequester() {
        super(Material.field_151573_f, FACING_PROP);
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new TileRequester();
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer entityplayer, EnumFacing face, float hitX, float hitY,
            float hitZ) {
        if (super.func_180639_a(world, pos, state, entityplayer, face, hitX, hitY, hitZ)) {
            return true;
        }

        if (!world.field_72995_K) {
            entityplayer.openGui(BuildCraftRobotics.instance, GuiIds.REQUESTER, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }

        return true;
    }

    @Override
    public boolean doesSlotCountComparator(TileEntity tile, int slot, ItemStack stack) {
        return ((TileRequester) tile).getRequestTemplate(slot) != null;
    }
}
