/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.robotics;

import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(Side.CLIENT)
public class EntityRobotEnergyParticle extends EntityFX {
    private float smokeParticleScale;

    public EntityRobotEnergyParticle(World world, double x, double y, double z, double vx, double vy, double vz) {
        this(world, x, y, z, vx, vy, vz, 1.0F);
    }

    public EntityRobotEnergyParticle(World world, double x, double y, double z, double vx, double vy, double vz, float size) {
        super(world, x, y, z, vx, vy, vz);
        this.field_70159_w *= 0.10000000149011612D;
        this.field_70181_x *= 0.10000000149011612D;
        this.field_70179_y *= 0.10000000149011612D;
        this.field_70159_w += vx;
        this.field_70181_x += vy;
        this.field_70179_y += vz;
        this.field_70552_h = (float) (Math.random() * 0.6);
        this.field_70553_i = 0;
        this.field_70551_j = 0;
        this.field_70544_f *= 0.75F;
        this.field_70544_f *= size;
        this.smokeParticleScale = this.field_70544_f;
        this.field_70547_e = (int) (16.0D / (Math.random() * 0.8D + 0.2D));
        this.field_70547_e = (int) (this.field_70547_e * size);
        this.field_70145_X = false;
    }

    @Override
    public void func_180434_a(WorldRenderer worldRenderer, Entity entity, float partialTicks, float f1, float f2, float f3, float f4, float f5) {
        float f6 = (this.field_70546_d + partialTicks) / this.field_70547_e * 32.0F;

        if (f6 < 0.0F) {
            f6 = 0.0F;
        }

        if (f6 > 1.0F) {
            f6 = 1.0F;
        }

        this.field_70544_f = this.smokeParticleScale * f6;// FIXME EntityRobotEnergyParticle
        super.func_180434_a(worldRenderer, entity, partialTicks, f1, f2, f3, f4, f5);
    }

    /** Called to update the entity's position/logic. */
    @Override
    public void func_70071_h_() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;

        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_70106_y();
        }

        this.func_70536_a(7 - this.field_70546_d * 8 / this.field_70547_e);
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);

        this.field_70159_w *= 0.98;
        this.field_70181_x += 0.0005;
        this.field_70179_y *= 0.98;

        if (this.field_70122_E) {
            this.field_70159_w *= 0.699999988079071D;
            this.field_70179_y *= 0.699999988079071D;
        }
    }
}
