/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.robotics;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IChatComponent;

import net.minecraftforge.fml.relauncher.Side;

import buildcraft.BuildCraftCore;
import buildcraft.api.robots.IRequestProvider;
import buildcraft.core.lib.block.TileBuildCraft;
import buildcraft.core.lib.inventory.SimpleInventory;
import buildcraft.core.lib.inventory.StackHelper;
import buildcraft.core.lib.network.command.CommandWriter;
import buildcraft.core.lib.network.command.ICommandReceiver;
import buildcraft.core.lib.network.command.PacketCommand;
import buildcraft.core.lib.utils.NetworkUtils;

import io.netty.buffer.ByteBuf;

public class TileRequester extends TileBuildCraft implements IInventory, IRequestProvider, ICommandReceiver {
    public static final int NB_ITEMS = 20;

    private SimpleInventory inv = new SimpleInventory(NB_ITEMS, "items", 64);
    private SimpleInventory requests = new SimpleInventory(NB_ITEMS, "requests", 64);

    public TileRequester() {

    }

    public void setRequest(final int index, final ItemStack stack) {
        if (field_145850_b.field_72995_K) {
            BuildCraftCore.instance.sendToServer(new PacketCommand(this, "setRequest", new CommandWriter() {
                @Override
                public void write(ByteBuf data) {
                    data.writeByte(index);
                    NetworkUtils.writeStack(data, stack);
                }
            }));
        } else {
            requests.func_70299_a(index, stack);
        }
    }

    @Override
    public void receiveCommand(String command, Side side, Object sender, ByteBuf stream) {
        if (side.isServer() && "setRequest".equals(command)) {
            setRequest(stream.readUnsignedByte(), NetworkUtils.readStack(stream));
        }
    }

    public ItemStack getRequestTemplate(int index) {
        return requests.func_70301_a(index);
    }

    @Override
    public int func_70302_i_() {
        return inv.func_70302_i_();
    }

    @Override
    public ItemStack func_70301_a(int slotId) {
        return inv.func_70301_a(slotId);
    }

    @Override
    public ItemStack func_70298_a(int slotId, int count) {
        return inv.func_70298_a(slotId, count);
    }

    @Override
    public ItemStack func_70304_b(int slotId) {
        return inv.func_70304_b(slotId);
    }

    @Override
    public void func_70299_a(int slotId, ItemStack itemStack) {
        inv.func_70299_a(slotId, itemStack);
    }

    @Override
    public IChatComponent getDisplayName() {
        return inv.func_145748_c_();
    }

    @Override
    public boolean hasCustomName() {
        return inv.func_145818_k_();
    }

    @Override
    public int func_70297_j_() {
        return inv.func_70297_j_();
    }

    @Override
    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return inv.func_70300_a(entityPlayer);
    }

    @Override
    public void func_174889_b(EntityPlayer player) {
        inv.func_174889_b(player);
    }

    @Override
    public void func_174886_c(EntityPlayer player) {
        inv.func_174886_c(player);
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemStack) {
        if (requests.func_70301_a(i) == null) {
            return false;
        } else if (!StackHelper.isMatchingItemOrList(requests.func_70301_a(i), itemStack)) {
            return false;
        } else {
            return inv.func_94041_b(i, itemStack);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);

        NBTTagCompound invNBT = new NBTTagCompound();
        inv.writeToNBT(invNBT);
        nbt.func_74782_a("inv", invNBT);

        NBTTagCompound reqNBT = new NBTTagCompound();
        requests.writeToNBT(reqNBT);
        nbt.func_74782_a("req", reqNBT);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);

        inv.readFromNBT(nbt.func_74775_l("inv"));
        requests.readFromNBT(nbt.func_74775_l("req"));
    }

    public boolean isFulfilled(int i) {
        if (requests.func_70301_a(i) == null) {
            return true;
        } else if (inv.func_70301_a(i) == null) {
            return false;
        } else {
            return StackHelper.isMatchingItemOrList(requests.func_70301_a(i), inv.func_70301_a(i)) && inv.func_70301_a(i).field_77994_a >= requests
                    .func_70301_a(i).field_77994_a;
        }
    }

    @Override
    public int getRequestsCount() {
        return NB_ITEMS;
    }

    @Override
    public ItemStack getRequest(int i) {
        if (requests.func_70301_a(i) == null) {
            return null;
        } else if (isFulfilled(i)) {
            return null;
        } else {
            ItemStack request = requests.func_70301_a(i).func_77946_l();

            ItemStack existingStack = inv.func_70301_a(i);
            if (existingStack == null) {
                return request;
            }

            if (!StackHelper.isMatchingItemOrList(request, existingStack)) {
                return null;
            }

            request.field_77994_a -= existingStack.field_77994_a;
            if (request.field_77994_a <= 0) {
                return null;
            }

            return request;
        }
    }

    @Override
    public ItemStack offerItem(int i, ItemStack stack) {
        ItemStack existingStack = inv.func_70301_a(i);

        if (requests.func_70301_a(i) == null) {
            return stack;
        } else if (existingStack == null) {
            if (!StackHelper.isMatchingItemOrList(stack, requests.func_70301_a(i))) {
                return stack;
            }

            int maxQty = requests.func_70301_a(i).field_77994_a;

            if (stack.field_77994_a <= maxQty) {
                inv.func_70299_a(i, stack);

                return null;
            } else {
                ItemStack newStack = stack.func_77946_l();
                newStack.field_77994_a = maxQty;
                stack.field_77994_a -= maxQty;

                inv.func_70299_a(i, newStack);

                return stack;
            }
        } else if (!StackHelper.isMatchingItemOrList(stack, existingStack)) {
            return stack;
        } else if (StackHelper.isMatchingItemOrList(stack, requests.func_70301_a(i))) {
            int maxQty = requests.func_70301_a(i).field_77994_a;

            if (existingStack.field_77994_a + stack.field_77994_a <= maxQty) {
                existingStack.field_77994_a += stack.field_77994_a;
                return null;
            } else {
                stack.field_77994_a -= maxQty - existingStack.field_77994_a;
                existingStack.field_77994_a = maxQty;
                return stack;
            }
        } else {
            return stack;
        }
    }
}
