/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.robotics.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;

import buildcraft.api.core.IStackFilter;
import buildcraft.api.core.IZone;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.lib.inventory.TransactorSimple;
import buildcraft.core.lib.utils.Utils;
import buildcraft.robotics.boards.BoardRobotPicker;

public class AIRobotFetchItem extends AIRobot {

    private EntityItem target;

    private float maxRange;
    private IStackFilter stackFilter;
    private int pickTime = -1;
    private IZone zone;

    public AIRobotFetchItem(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotFetchItem(EntityRobotBase iRobot, float iMaxRange, IStackFilter iStackFilter, IZone iZone) {
        this(iRobot);

        maxRange = iMaxRange;
        stackFilter = iStackFilter;
        zone = iZone;
    }

    @Override
    public void preempt(AIRobot ai) {
        if (target != null && target.field_70128_L) {
            terminate();
        }
    }

    @Override
    public void update() {
        if (target == null) {
            scanForItem();
        } else {
            pickTime++;

            if (pickTime > 5) {
                TransactorSimple inventoryInsert = new TransactorSimple(robot, null);

                target.func_92059_d().field_77994_a -= inventoryInsert.inject(target.func_92059_d(), true);

                if (target.func_92059_d().field_77994_a <= 0) {
                    target.func_70106_y();
                }

                terminate();
            }
        }
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotGotoBlock) {
            if (target == null) {
                // This would happen after a load. As we reached the item
                // location already, just consider that the item is not there
                // anymore and allow user to try to find another one.
                setSuccess(false);
                terminate();
                return;
            }

            if (!ai.success()) {
                robot.unreachableEntityDetected(target);
                setSuccess(false);
                terminate();
            }
        }
    }

    @Override
    public void end() {
        if (target != null) {
            BoardRobotPicker.targettedItems.remove(target.func_145782_y());
        }
    }

    private void scanForItem() {
        double previousDistance = Double.MAX_VALUE;
        TransactorSimple inventoryInsert = new TransactorSimple(robot, null);

        for (Object o : robot.worldObj.loadedEntityList) {
            Entity e = (Entity) o;

            if (!e.field_70128_L && e instanceof EntityItem && !BoardRobotPicker.targettedItems.contains(e.func_145782_y()) && !robot.isKnownUnreachable(e)
                && (zone == null || zone.contains(Utils.getVec(e)))) {
                double dx = e.field_70165_t - robot.posX;
                double dy = e.field_70163_u - robot.posY;
                double dz = e.field_70161_v - robot.posZ;

                double sqrDistance = dx * dx + dy * dy + dz * dz;
                double maxDistance = maxRange * maxRange;

                if (sqrDistance >= maxDistance) {
                    continue;
                } else if (stackFilter != null && !stackFilter.matches(((EntityItem) e).func_92059_d())) {
                    continue;
                } else {
                    EntityItem item = (EntityItem) e;

                    if (inventoryInsert.inject(item.func_92059_d(), false) > 0) {
                        if (target == null) {
                            previousDistance = sqrDistance;
                            target = item;
                        } else {
                            if (sqrDistance < previousDistance) {
                                previousDistance = sqrDistance;
                                target = item;
                            }
                        }
                    }
                }
            }
        }

        if (target != null) {
            BoardRobotPicker.targettedItems.add(target.func_145782_y());
            if (Math.floor(target.field_70165_t) != Math.floor(robot.posX) || Math.floor(target.field_70163_u) != Math.floor(robot.posY) || Math.floor(
                    target.field_70161_v) != Math.floor(robot.posZ)) {
                startDelegateAI(new AIRobotGotoBlock(robot, Utils.getPos(target)));
            }
        } else {
            // No item was found, terminate this AI
            setSuccess(false);
            terminate();
        }
    }

    @Override
    public int getEnergyCost() {
        return 15;
    }
}
