/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.robotics.ai;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;

import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.DockingStation;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.lib.utils.NBTUtils;
import buildcraft.core.lib.utils.Utils;

public class AIRobotGoAndLinkToDock extends AIRobot {

    private DockingStation station;

    public AIRobotGoAndLinkToDock(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotGoAndLinkToDock(EntityRobotBase iRobot, DockingStation iStation) {
        this(iRobot);

        station = iStation;
    }

    @Override
    public void start() {
        if (station == robot.getLinkedStation() && station == robot.getDockingStation()) {
            terminate();
        } else {
            if (station != null && station.takeAsMain(robot)) {
                startDelegateAI(new AIRobotGotoBlock(robot, station.getPos().offset(station.side(), 2)));
            } else {
                setSuccess(false);
                terminate();
            }
        }
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotGotoBlock) {
            if (ai.success()) {
                startDelegateAI(new AIRobotStraightMoveTo(robot, Utils.convertMiddle(station.getPos()).add(Utils.convert(station.side(), 0.5))));
            } else {
                terminate();
            }
        } else if (ai instanceof AIRobotStraightMoveTo) {
            if (ai.success()) {
                robot.dock(station);
            }
            terminate();
        }
    }

    @Override
    public boolean canLoadFromNBT() {
        return true;
    }

    @Override
    public void writeSelfToNBT(NBTTagCompound nbt) {
        super.writeSelfToNBT(nbt);

        if (station != null && station.index() != null) {
            nbt.func_74782_a("stationIndex", NBTUtils.writeBlockPos(station.index()));
            nbt.func_74774_a("stationSide", (byte) station.side().ordinal());
        }
    }

    @Override
    public void loadSelfFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("stationIndex")) {
            BlockPos index = NBTUtils.readBlockPos(nbt.func_74781_a("stationIndex"));
            EnumFacing side = EnumFacing.values()[nbt.func_74771_c("stationSide")];

            station = robot.getRegistry().getStation(index, side);
        } else {
            station = robot.getLinkedStation();
        }
    }
}
