/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.robotics.ai;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;

import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.lib.utils.Utils;

public class AIRobotStraightMoveTo extends AIRobotGoto {

    private double prevDistance = Double.MAX_VALUE;

    private Vec3 pos;

    public AIRobotStraightMoveTo(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotStraightMoveTo(EntityRobotBase iRobot, Vec3 pos) {
        this(iRobot);
        this.pos = pos;
        robot.aimItemAt(Utils.convertFloor(pos));
    }

    @Override
    public void start() {
        robot.undock();
        setDestination(robot, pos);
    }

    @Override
    public void update() {
        double distance = Utils.getVec(robot).distanceTo(next);

        if (distance < prevDistance) {
            prevDistance = distance;
        } else {
            robot.motionX = 0;
            robot.motionY = 0;
            robot.motionZ = 0;

            robot.posX = pos.field_72450_a;
            robot.posY = pos.field_72448_b;
            robot.posZ = pos.field_72449_c;

            terminate();
        }
    }

    @Override
    public boolean canLoadFromNBT() {
        return true;
    }

    @Override
    public void writeSelfToNBT(NBTTagCompound nbt) {
        super.writeSelfToNBT(nbt);

        nbt.func_74776_a("x", (float) pos.field_72450_a);
        nbt.func_74776_a("y", (float) pos.field_72448_b);
        nbt.func_74776_a("z", (float) pos.field_72449_c);
    }

    @Override
    public void loadSelfFromNBT(NBTTagCompound nbt) {
        super.loadSelfFromNBT(nbt);

        if (nbt.func_74764_b("x")) {
            float x = nbt.func_74760_g("x");
            float y = nbt.func_74760_g("y");
            float z = nbt.func_74760_g("z");
            pos = new Vec3(x, y, z);
        }
    }
}
