/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.robotics.gui;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import io.netty.buffer.ByteBuf;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.EnumColor;
import buildcraft.core.DefaultProps;
import buildcraft.core.lib.client.sprite.DynamicTextureBC;
import buildcraft.core.lib.gui.AdvancedSlot;
import buildcraft.core.lib.gui.GuiAdvancedInterface;
import buildcraft.core.lib.gui.buttons.GuiBetterButton;
import buildcraft.core.lib.gui.buttons.StandardButtonTextureSets;
import buildcraft.core.lib.gui.tooltips.ToolTip;
import buildcraft.core.lib.gui.tooltips.ToolTipLine;
import buildcraft.core.lib.network.command.CommandWriter;
import buildcraft.core.lib.network.command.PacketCommand;
import buildcraft.core.lib.utils.BCStringUtils;
import buildcraft.core.lib.utils.NetworkUtils;
import buildcraft.robotics.TileZonePlan;
import buildcraft.robotics.ZonePlan;

public class GuiZonePlan extends GuiAdvancedInterface {

    private static final ResourceLocation TMP_TEXTURE = new ResourceLocation("buildcraftrobotics:textures/gui/zone_planner_gui.png");

    private int mapWidth = 213;
    private int mapHeight = 100;

    private TileZonePlan zonePlan;

    private DynamicTextureBC newSelection;
    private int selX1 = 0;
    private int selX2 = 0;
    private int selY1 = 0;
    private int selY2 = 0;

    private boolean inSelection = false;

    private DynamicTextureBC currentSelection;

    private int mapXMin = 0;
    private int mapYMin = 0;

    private float blocksPerPixel = 1.0f;
    private int cx;
    private int cz;

    private AreaSlot colorSelected = null;

    private float alpha = 0.8F;

    private GuiBetterButton tool, fsButton;

    private List<Slot> inventorySlots;
    private List<GuiButton> savedButtonList;

    private GuiTextField textField;

    private static class AreaSlot extends AdvancedSlot {

        public EnumColor color;

        public AreaSlot(GuiAdvancedInterface gui, int x, int y, EnumColor iColor) {
            super(gui, x, y);

            color = iColor;
        }

        @Override
        public TextureAtlasSprite getIcon() {
            return color.getSprite();
        }

        @Override
        public String getDescription() {
            return color.getLocalizedName();
        }
    }

    public GuiZonePlan(EntityPlayer player, TileZonePlan iZonePlan) {
        super(new ContainerZonePlan(player, iZonePlan), player.field_71071_by, TMP_TEXTURE);

        getContainer().gui = this;

        field_146999_f = 256;
        field_147000_g = 228;

        zonePlan = iZonePlan;

        getContainer().mapTexture = new DynamicTextureBC(mapWidth, mapHeight);
        currentSelection = new DynamicTextureBC(mapWidth, mapHeight);
        newSelection = new DynamicTextureBC(1, 1);

        getContainer().currentAreaSelection = new ZonePlan();

        cx = zonePlan.func_174877_v().func_177958_n();
		cz = zonePlan.func_174877_v().func_177952_p();

        resetNullSlots(16);

        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                slots.set(i * 4 + j, new AreaSlot(this, 8 + 18 * i, 146 + 18 * j, EnumColor.values()[i * 4 + j]));
            }
        }

        colorSelected = (AreaSlot) slots.get(0);

        newSelection.setColor(0, 0, colorSelected.color.getDarkHex(), alpha);

        uploadMap();
        getContainer().loadArea(colorSelected.color.ordinal());

        inventorySlots = container.field_75151_b;
    }

    @SuppressWarnings("unchecked")
    @Override
    public void func_73866_w_() {
        super.func_73866_w_();

        tool = new GuiBetterButton(0, field_147003_i + 27, field_147009_r + 111, 15, StandardButtonTextureSets.SMALL_BUTTON, "+");
        tool.setToolTip(new ToolTip(new ToolTipLine(BCStringUtils.localize("tip.tool.add"))));
        field_146292_n.add(tool);
        fsButton = new GuiBetterButton(1, field_147003_i + 44, field_147009_r + 111, 20, StandardButtonTextureSets.SMALL_BUTTON, "FS");
        fsButton.setToolTip(new ToolTip(new ToolTipLine(BCStringUtils.localize("tip.tool.fullscreen"))));
        field_146292_n.add(fsButton);

        savedButtonList = field_146292_n;

        textField = new GuiTextField(1, this.field_146289_q, 28, 129, 156, 12);
        textField.func_146203_f(DefaultProps.MAX_NAME_SIZE);
        textField.func_146180_a(zonePlan.mapName);
        textField.func_146195_b(true);
    }

    private void uploadMap() {
        BuildCraftCore.instance.sendToServer(new PacketCommand(getContainer(), "computeMap", new CommandWriter() {
            @Override
            public void write(ByteBuf data) {
                data.writeInt(cx);
                data.writeInt(cz);
                data.writeShort(getContainer().mapTexture.width);
                data.writeShort(getContainer().mapTexture.height);
                data.writeFloat(blocksPerPixel);
            }
        }));
    }

    private boolean isFullscreen() {
        return getContainer().mapTexture.height > 100;
    }

    @Override
    protected void func_146976_a(float f, int x, int y) {
        super.func_146976_a(f, x, y);

        if (getContainer().mapTexture.width <= 213) {
            mapXMin = field_147003_i + 8 + ((213 - getContainer().mapTexture.width) / 2);
        } else {
            mapXMin = (field_146294_l - getContainer().mapTexture.width) / 2;
        }

        if (getContainer().mapTexture.height <= 100) {
            mapYMin = field_147009_r + 9 + ((100 - getContainer().mapTexture.height) / 2);
        } else {
            mapYMin = (field_146295_m - getContainer().mapTexture.height) / 2;
        }

        getContainer().mapTexture.draw(mapXMin, mapYMin, field_73735_i);

        GL11.glPushAttrib(GL11.GL_ENABLE_BIT);
        GL11.glEnable(GL11.GL_BLEND);

        currentSelection.draw(mapXMin, mapYMin, field_73735_i);

        GL11.glPopAttrib();
        GL11.glDisable(GL11.GL_BLEND);

        newSelection.updateTexture();

        if (inSelection && selX2 != 0) {
            GL11.glPushAttrib(GL11.GL_ENABLE_BIT);
            GL11.glEnable(GL11.GL_BLEND);

            int x1 = selX1 < selX2 ? selX1 : selX2;
            int x2 = selX1 < selX2 ? selX2 : selX1;
            int y1 = selY1 < selY2 ? selY1 : selY2;
            int y2 = selY1 < selY2 ? selY2 : selY1;

            func_73729_b(x1, y1, 0, 0, x2 - x1 + 1, y2 - y1 + 1);
            GL11.glPopAttrib();
            GL11.glDisable(GL11.GL_BLEND);
        }

        if (!isFullscreen()) {
            drawBackgroundSlots(x, y);

            bindTexture(texture);

            GL11.glEnable(GL11.GL_ALPHA_TEST);
            func_73729_b(field_147003_i + colorSelected.x, field_147009_r + colorSelected.y, 0, 228, 16, 16);
            func_73729_b(field_147003_i + 236, field_147009_r + 27, 16, 228, 8, (int) ((zonePlan.progress / (float) TileZonePlan.CRAFT_TIME) * 27));
        }
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        super.func_146979_b(par1, par2);
        if (!isFullscreen()) {
            textField.func_146194_f();
        }
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        int blocksX = Math.round((mouseX - mapXMin) * blocksPerPixel);
        int blocksZ = Math.round((mouseY - mapYMin) * blocksPerPixel);

        int blockStartX = Math.round(cx - mapWidth * blocksPerPixel / 2);
        int blockStartZ = Math.round(cz - mapHeight * blocksPerPixel / 2);

        boolean clickOnMap = mouseX >= mapXMin && mouseX <= mapXMin + getContainer().mapTexture.width && mouseY >= mapYMin && mouseY <= mapYMin
            + getContainer().mapTexture.height;

        if (clickOnMap) {
            if (mouseButton == 1) {
                cx = blockStartX + blocksX;
                cz = blockStartZ + blocksZ;

                uploadMap();
                refreshSelectedArea();
                return;
            } else {
                inSelection = true;
                selX1 = mouseX;
                selY1 = mouseY;
                selX2 = 0;
                selY2 = 0;
                return;
            }
        }

        super.func_73864_a(mouseX, mouseY, mouseButton);
        textField.func_146192_a(mouseX - field_147003_i, mouseY - field_147009_r, mouseButton);

        AdvancedSlot slot = getSlotAtLocation(mouseX, mouseY);

        if (slot instanceof AreaSlot) {
            colorSelected = (AreaSlot) slot;

            newSelection.setColor(0, 0, colorSelected.color.getDarkHex(), alpha);
            getContainer().loadArea(colorSelected.color.ordinal());
        }
    }

    @Override
    protected void func_146273_a(int mouseX, int mouseY, int lastButtonBlicked, long time) {
        super.func_146273_a(mouseX, mouseY, lastButtonBlicked, time);

        if (inSelection && mouseX >= mapXMin && mouseX <= mapXMin + getContainer().mapTexture.width && mouseY >= mapYMin && mouseY <= mapYMin
            + getContainer().mapTexture.height) {

            selX2 = mouseX;
            selY2 = mouseY;
        }
    }

    // TODO: Test, see if Released is MovedOrUp
    @Override
    protected void func_146286_b(int mouseX, int mouseY, int eventType) {
        super.func_146286_b(mouseX, mouseY, eventType);

        if (eventType != -1 && inSelection) {
            boolean val = tool.field_146126_j.equals("+");
            int blockStartX = Math.round(cx - mapWidth * blocksPerPixel / 2);
            int blockStartZ = Math.round(cz - mapHeight * blocksPerPixel / 2);

            int x1 = selX1 < selX2 ? selX1 : selX2;
            int x2 = selX1 < selX2 ? selX2 : selX1;
            int y1 = selY1 < selY2 ? selY1 : selY2;
            int y2 = selY1 < selY2 ? selY2 : selY1;

            int lengthX = Math.round((x2 - x1) * blocksPerPixel);
            int lengthY = Math.round((y2 - y1) * blocksPerPixel);

            for (int i = 0; i <= lengthX; ++i) {
                for (int j = 0; j <= lengthY; ++j) {
                    int x = Math.round(blockStartX + (x1 - mapXMin) * blocksPerPixel) + i;
                    int z = Math.round(blockStartZ + (y1 - mapYMin) * blocksPerPixel) + j;

                    getContainer().currentAreaSelection.set(x, z, val);
                }
            }

            inSelection = false;
            getContainer().saveArea(colorSelected.color.ordinal());
            refreshSelectedArea();
        }
    }

    private void toFullscreen() {
        if (blocksPerPixel > 4.0f) {
            blocksPerPixel = 4.0f;
        }

        mapWidth = this.field_146297_k.field_71443_c;
        mapHeight = this.field_146297_k.field_71440_d;

        getContainer().mapTexture = new DynamicTextureBC(mapWidth, mapHeight);
        currentSelection = new DynamicTextureBC(mapWidth, mapHeight);

        uploadMap();
        refreshSelectedArea();

        container.field_75151_b = new LinkedList<>();
        field_146292_n = new LinkedList<>();
    }

    private void toWindowed() {
        mapWidth = 213;
        mapHeight = 100;

        getContainer().mapTexture = new DynamicTextureBC(mapWidth, mapHeight);
        currentSelection = new DynamicTextureBC(mapWidth, mapHeight);

        uploadMap();
        refreshSelectedArea();

        container.field_75151_b = inventorySlots;
        field_146292_n = savedButtonList;
    }

    private boolean incBlocksPerPixel() {
        if (blocksPerPixel > 0.125f) {
            if (blocksPerPixel <= 1.0f) {
                blocksPerPixel /= 2;
            } else {
                blocksPerPixel--;
            }
            return true;
        }
        return false;
    }

    private boolean decBlocksPerPixel() {
        if ((isFullscreen() && blocksPerPixel < 4.0f) || (!isFullscreen() && blocksPerPixel < 8.0f)) {
            if (blocksPerPixel >= 1.0f) {
                blocksPerPixel++;
            } else {
                blocksPerPixel *= 2;
            }
            return true;
        }
        return false;
    }

    @Override
    protected void func_73869_a(char carac, int val) throws IOException {
        if (!isFullscreen() && textField.func_146206_l()) {
            if (carac == 13 || carac == 27) {
                textField.func_146195_b(false);
            } else {
                textField.func_146201_a(carac, val);
                final String text = textField.func_146179_b();
                BuildCraftCore.instance.sendToServer(new PacketCommand(getContainer(), "setName", new CommandWriter() {
                    @Override
                    public void write(ByteBuf data) {
                        NetworkUtils.writeUTF(data, text);
                    }
                }));
            }
            return;
        } else if (val == Keyboard.KEY_F5) {
            uploadMap();
            refreshSelectedArea();
        } else if (carac == '+' && incBlocksPerPixel()) {
            uploadMap();
            refreshSelectedArea();
        } else if (carac == '-' && decBlocksPerPixel()) {
            uploadMap();
            refreshSelectedArea();
        } else if (carac == 'm' || (carac == 27 && isFullscreen())) {
            toWindowed();
        } else if (carac == 'M') {
            toFullscreen();
        } else {
            super.func_73869_a(carac, val);
        }
    }

    public void refreshSelectedArea() {
        int color = colorSelected.color.getDarkHex();

        int rAdd = (color >> 16) & 255;
        int gAdd = (color >> 8) & 255;
        int bAdd = color & 255;

        for (int i = 0; i < currentSelection.width; ++i) {
            for (int j = 0; j < currentSelection.height; ++j) {
                int blockStartX = Math.round(cx - mapWidth * blocksPerPixel / 2);
                int blockStartZ = Math.round(cz - mapHeight * blocksPerPixel / 2);
                int c = (int) Math.ceil(blocksPerPixel);

                double r = 0;
                double g = 0;
                double b = 0;

                for (int stepi = 0; stepi < c; ++stepi) {
                    for (int stepj = 0; stepj < c; ++stepj) {
                        int x = Math.round(blockStartX + i * blocksPerPixel) + stepi;
                        int z = Math.round(blockStartZ + j * blocksPerPixel) + stepj;

                        if (getContainer().currentAreaSelection.get(x, z)) {
                            r += rAdd;
                            g += gAdd;
                            b += bAdd;
                        }
                    }
                }

                r /= c * c;
                g /= c * c;
                b /= c * c;

                if (r != 0) {
                    currentSelection.setColori(i, j, (int) r, (int) g, (int) b, (int) (alpha * 255.0F));
                } else {
                    currentSelection.setColori(i, j, 0, 0, 0, 0);
                }
            }
        }
    }

    @Override
    public ContainerZonePlan getContainer() {
        return (ContainerZonePlan) super.getContainer();
    }

    @Override
    protected void func_146284_a(GuiButton button) {
        if (button == tool) {
            if (tool.field_146126_j.equals("+")) {
                tool.field_146126_j = "-";
                tool.getToolTip().remove(0);
                tool.getToolTip().add(new ToolTipLine(BCStringUtils.localize("tip.tool.remove")));
            } else {
                tool.field_146126_j = "+";
                tool.getToolTip().remove(0);
                tool.getToolTip().add(new ToolTipLine(BCStringUtils.localize("tip.tool.add")));
            }
        } else if (button == fsButton) {
            toFullscreen();
        }
    }

    @Override
    public void func_146274_d() throws IOException {
        super.func_146274_d();

        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;

        if (mouseX >= mapXMin && mouseX <= mapXMin + getContainer().mapTexture.width && mouseY >= mapYMin && mouseY <= mapYMin
            + getContainer().mapTexture.height) {
            int wheel = Mouse.getEventDWheel();
            if (wheel != 0) {
                if (wheel > 0 && decBlocksPerPixel()) {
                    uploadMap();
                    refreshSelectedArea();
                } else if (wheel < 0 && incBlocksPerPixel()) {
                    uploadMap();
                    refreshSelectedArea();
                }
            }
        }
    }
}
