package buildcraft.robotics.map;

import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.world.chunk.Chunk;

import buildcraft.api.core.BCLog;

public class MapChunk {
    private static final int VERSION = 1;

    private int x, z;
    private byte[] data;

    public MapChunk(int x, int z) {
        this.x = x;
        this.z = z;
        data = new byte[256];
    }

    public MapChunk(NBTTagCompound compound) {
        readFromNBT(compound);
    }

    public int getX() {
        return x;
    }

    public int getZ() {
        return z;
    }

    public int getColor(int x, int z) {
        return (int) data[((z & 15) << 4) | (x & 15)];
    }

    public void update(Chunk chunk) {
        for (int bz = 0; bz < 16; bz++) {
            for (int bx = 0; bx < 16; bx++) {
                int y = chunk.func_76611_b(bx, bz);
                int color = MapColor.field_151660_b.field_76290_q;

                if (y < 0) {
                    y = 255;
                }

                Block b;
                IBlockState state;

                while (y >= 0) {
                    state = chunk.func_177435_g(new BlockPos(bx, y, bz));
                    b = state.func_177230_c();

                    color = b.func_180659_g(state) != null ? b.func_180659_g(state).field_76290_q : MapColor.field_151660_b.field_76290_q;
                    if (color != MapColor.field_151660_b.field_76290_q) {
                        break;
                    }
                    y--;
                }

                data[(bz << 4) | bx] = (byte) color;
            }
        }
    }

    public void readFromNBT(NBTTagCompound compound) {
        int version = compound.func_74765_d("version");
        if (version > MapChunk.VERSION) {
            BCLog.logger.error("Unsupported MapChunk version: " + version);
            return;
        }
        x = compound.func_74762_e("x");
        z = compound.func_74762_e("z");
        data = compound.func_74770_j("data");
        if (data.length != 256) {
            BCLog.logger.error("Invalid MapChunk data length: " + data.length);
            data = new byte[256];
        }
    }

    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74777_a("version", (short) VERSION);
        compound.func_74768_a("x", x);
        compound.func_74768_a("z", z);
        compound.func_74773_a("data", data);
    }

    @Override
    public int hashCode() {
        return 31 * x + z;
    }
}
