package buildcraft.robotics.map;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IntHashMap;

import buildcraft.api.core.INBTStoreable;

public class MapRegion implements INBTStoreable {
    private final IntHashMap<MapChunk> chunks = new IntHashMap<>();
    private final int x, z;

    public MapRegion(int x, int z) {
        this.x = x;
        this.z = z;
    }

    public int getX() {
        return x;
    }

    public int getZ() {
        return z;
    }

    public boolean hasChunk(int x, int z) {
        return chunks.func_76037_b((z << 4) | x);
    }

    public MapChunk getChunk(int x, int z) {
        int id = (z << 4) | x;
        MapChunk chunk = chunks.func_76041_a(id);
        if (chunk == null) {
            chunk = new MapChunk(x, z);
            chunks.func_76038_a(id, chunk);
        }
        return chunk;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        chunks.func_76046_c();

        if (tag != null) {
            for (int i = 0; i < 256; i++) {
                if (tag.func_74764_b("r" + i)) {
                    MapChunk chunk = new MapChunk(tag.func_74775_l("r" + i));
                    chunks.func_76038_a(i, chunk);
                }
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        for (int i = 0; i < 256; i++) {
            MapChunk chunk = chunks.func_76041_a(i);
            if (chunk != null) {
                NBTTagCompound chunkNBT = new NBTTagCompound();
                synchronized (chunk) {
                    chunk.writeToNBT(chunkNBT);
                }
                tag.func_74782_a("r" + i, chunkNBT);
            }
        }
    }
}
