/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.silicon;

import java.util.EnumMap;
import java.util.List;

import com.google.common.collect.Maps;

import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

import buildcraft.core.BCCreativeTab;
import buildcraft.core.lib.block.BlockBuildCraft;
import buildcraft.core.lib.client.render.ICustomHighlight;
import buildcraft.core.lib.utils.MatrixUtils;

public class BlockLaser extends BlockBuildCraft implements ICustomHighlight {
    private static final EnumMap<EnumFacing, AxisAlignedBB[]> boxesMap = Maps.newEnumMap(EnumFacing.class);

    static {
        for (EnumFacing face : EnumFacing.values()) {
            AxisAlignedBB[] array = new AxisAlignedBB[2];
            array[0] = new AxisAlignedBB(0, 0, 0, 1, 0.25, 1);
            array[1] = new AxisAlignedBB(5 / 16.0, 4 / 16.0, 5 / 16.0, 11 / 16.0, 13 / 16.0, 11 / 16.0);
            array = MatrixUtils.multiplyAll(array, MatrixUtils.rotateTowardsFace(EnumFacing.UP, face));
            boxesMap.put(face, array);
        }
    }

    public BlockLaser() {
        super(Material.field_151573_f, FACING_6_PROP);
        func_149711_c(10F);
        func_149647_a(BCCreativeTab.get("main"));
        func_180632_j(func_176223_P().func_177226_a(FACING_6_PROP, EnumFacing.UP));
    }

    @Override
    public AxisAlignedBB[] getBoxes(IBlockAccess access, BlockPos pos, IBlockState state) {
        return boxesMap.get(state.func_177229_b(FACING_6_PROP));
    }

    @Override
    public double getExpansion() {
        return 0.0075;
    }

    @Override
    public double getBreathingCoefficent() {
        return 0.725;
    }

    @Override
    public void func_180638_a(World wrd, BlockPos pos, IBlockState state, AxisAlignedBB mask, List<AxisAlignedBB> list, Entity ent) {
        AxisAlignedBB[] aabbs = getBoxes(wrd, pos, state);
        for (AxisAlignedBB aabb : aabbs) {
            AxisAlignedBB aabbTmp = aabb.func_72317_d(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            if (mask.func_72326_a(aabbTmp)) {
                list.add(aabbTmp);
            }
        }
    }

    @Override
    public boolean func_149662_c() {
        return false;
    }

    @Override
    public boolean func_149686_d() {
        return false;
    }

    @Override
    public TileEntity func_149915_a(World world, int metadata) {
        return new TileLaser();
    }

    @Override
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta,
            EntityLivingBase placer) {
        return super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer);
    }

    // @Override
    // public int onBlockPlaced(World world, BlockPos pos, EnumFacing face, float par6, float par7, float par8, int
    // meta) {
    // super.onBlockPlaced(world, pos, side, par6, par7, par8, meta);
    //
    // int retMeta = meta;
    //
    // if (side <= 6) {
    // retMeta = side;
    // }
    //
    // return retMeta;
    // }

    @Override
    public boolean isSideSolid(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }
}
