/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.silicon;

import buildcraft.BuildCraftSilicon;
import buildcraft.api.enums.EnumLaserTableType;
import buildcraft.api.power.ILaserTargetBlock;
import buildcraft.core.BCCreativeTab;
import buildcraft.core.lib.block.BlockBuildCraft;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import java.util.List;

public class BlockLaserTable extends BlockBuildCraft implements ILaserTargetBlock {
    public static final int TABLE_MAX = EnumLaserTableType.values().length;

    public BlockLaserTable() {
        super(Material.field_151573_f, LASER_TABLE_TYPE);
        func_149711_c(10F);
        func_149647_a(BCCreativeTab.get("main"));
    }

    @Override
    public boolean func_149662_c() {
        return false;
    }

    @Override
    public boolean func_149686_d() {
        return false;
    }

    @Override
    public EnumWorldBlockLayer func_180664_k() {
        return EnumWorldBlockLayer.CUTOUT;
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer entityplayer, EnumFacing side, float par7, float par8,
            float par9) {
        if (super.func_180639_a(world, pos, state, entityplayer, side, par7, par8, par9)) {
            return true;
        }

        // Drop through if the player is sneaking
        if (entityplayer.func_70093_af()) {
            return false;
        }

        if (!world.field_72995_K) {
            int ord = state.func_177229_b(LASER_TABLE_TYPE).ordinal();
            entityplayer.openGui(BuildCraftSilicon.instance, ord, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        EnumLaserTableType tableType = state.func_177229_b(LASER_TABLE_TYPE);
        switch (tableType) {
            case ASSEMBLY_TABLE:
                return new TileAssemblyTable();
            case ADVANCED_CRAFTING_TABLE:
                return new TileAdvancedCraftingTable();
            case INTEGRATION_TABLE:
                return new TileIntegrationTable();
            case CHARGING_TABLE:
                return new TileChargingTable();
            case PROGRAMMING_TABLE:
                return new TileProgrammingTable();
        }
        return null;
    }

    @Override
    public TileEntity func_149915_a(World world, int metadata) {
        return null;
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return state.func_177229_b(LASER_TABLE_TYPE).ordinal();
    }

    @SuppressWarnings({ "rawtypes", "unchecked" })
    @Override
    @SideOnly(Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs par2CreativeTabs, List par3List) {
        for (int i = 0; i < TABLE_MAX; i++) {
            par3List.add(new ItemStack(this, 1, i));
        }
    }

    @Override
    public AxisAlignedBB getBox(IBlockAccess world, BlockPos pos, IBlockState state) {
        return new AxisAlignedBB(0, 0, 0, 1, 9 / 16d, 1);
    }
}
