package buildcraft.silicon;

import net.minecraft.item.ItemStack;

import cofh.api.energy.IEnergyContainerItem;
import buildcraft.api.tiles.IHasWork;
import buildcraft.core.lib.utils.BCStringUtils;

public class TileChargingTable extends TileLaserTableBase implements IHasWork {
    @Override
    public void func_73660_a() {
        super.func_73660_a();

        if (field_145850_b.field_72995_K) {
            return;
        }

        if (getEnergy() > 0) {
            if (getRequiredEnergy() > 0) {
                ItemStack stack = this.func_70301_a(0);
                IEnergyContainerItem containerItem = (IEnergyContainerItem) stack.func_77973_b();
                addEnergy(0 - containerItem.receiveEnergy(stack, getEnergy(), false));
                this.func_70299_a(0, stack);
            } else {
                subtractEnergy(Math.min(getEnergy(), 10));
            }
        }
    }

    @Override
    public int getRequiredEnergy() {
        ItemStack stack = this.func_70301_a(0);
        if (stack != null && stack.func_77973_b() != null && stack.func_77973_b() instanceof IEnergyContainerItem) {
            IEnergyContainerItem containerItem = (IEnergyContainerItem) stack.func_77973_b();
            return containerItem.getMaxEnergyStored(stack) - containerItem.getEnergyStored(stack);
        }

        return 0;
    }

    @Override
    public boolean hasWork() {
        return getRequiredEnergy() > 0;
    }

    @Override
    public boolean canCraft() {
        return hasWork();
    }

    @Override
    public int func_70302_i_() {
        return 1;
    }

    @Override
    public String getInventoryName() {
        return BCStringUtils.localize("tile.chargingTableBlock.name");
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot == 0 && stack != null && stack.func_77973_b() != null && stack.func_77973_b() instanceof IEnergyContainerItem;
    }
}
