/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.silicon;

import java.util.ArrayList;
import java.util.List;

import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;

import buildcraft.api.recipes.BuildcraftRecipeRegistry;
import buildcraft.api.recipes.IIntegrationRecipe;
import buildcraft.core.lib.inventory.SimpleInventory;
import buildcraft.core.lib.inventory.StackHelper;
import buildcraft.core.lib.utils.NetworkUtils;
import buildcraft.core.lib.utils.BCStringUtils;
import buildcraft.core.lib.utils.Utils;

import io.netty.buffer.ByteBuf;

public class TileIntegrationTable extends TileLaserTableBase implements ISidedInventory {
    public static final int SLOT_OUTPUT = 9;

    private static final int CYCLE_LENGTH = 16;
    private static final int[] SLOTS = Utils.createSlotArray(0, 10);

    public final IInventory clientOutputInv = new SimpleInventory(1, "Preview", 64);

    private int tick = 0;
    private IIntegrationRecipe activeRecipe;
    private boolean activeRecipeValid = false;
    private int maxExpCountClient;

    @Override
    public void initialize() {
        super.initialize();

        updateRecipe();
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();

        if (field_145850_b.field_72995_K) {
            return;
        }

        if (activeRecipe == null || !activeRecipeValid) {
            setEnergy(0);
            return;
        }

        tick++;
        if (tick % CYCLE_LENGTH != 0) {
            return;
        }

        updateRecipeOutput();

        ItemStack output = clientOutputInv.func_70301_a(0);
        if (!isRoomForOutput(output)) {
            setEnergy(0);
            return;
        }

        if (getEnergy() >= activeRecipe.getEnergyCost()) {
            setEnergy(0);

            output = activeRecipe.craft(func_70301_a(0), getExpansions(), false);

            if (output != null) {
                ItemStack input = func_70301_a(0);

                if (input.field_77994_a > output.field_77994_a) {
                    input.field_77994_a -= output.field_77994_a;
                } else {
                    func_70299_a(0, null);
                }

                outputStack(output, this, 9, false);

                for (int i = 1; i < 9; i++) {
                    if (func_70301_a(i) != null && func_70301_a(i).field_77994_a == 0) {
                        func_70299_a(i, null);
                    }
                }
            }
        }
    }

    private List<ItemStack> getExpansions() {
        List<ItemStack> expansions = new ArrayList<>();
        for (int i = 1; i < 9; i++) {
            if (func_70301_a(i) != null) {
                expansions.add(func_70301_a(i));
            }
        }
        return expansions;
    }

    private void updateRecipeOutput() {
        ItemStack oldClientOutput = clientOutputInv.func_70301_a(0);

        activeRecipeValid = false;
        clientOutputInv.func_70299_a(0, null);

        if (activeRecipe != null) {
            List<ItemStack> expansions = getExpansions();

            if (expansions.size() > 0) {
                clientOutputInv.func_70299_a(0, activeRecipe.craft(func_70301_a(0), expansions, true));
            }
        }

        activeRecipeValid = clientOutputInv.func_70301_a(0) != null;

        if (!StackHelper.isEqualItem(clientOutputInv.func_70301_a(0), oldClientOutput)) {
            sendNetworkUpdate();
        }
    }

    private void setNewActiveRecipe() {
        ItemStack input = func_70301_a(0);
        if ((input != null && activeRecipe != null && activeRecipe.isValidInput(input)) || (input == null && activeRecipe == null)) {
            return;
        }

        activeRecipe = null;
        activeRecipeValid = false;

        if (input != null && input.func_77973_b() != null) {
            for (IIntegrationRecipe recipe : BuildcraftRecipeRegistry.integrationTable.getRecipes()) {
                if (recipe.isValidInput(input)) {
                    activeRecipe = recipe;
                    break;
                }
            }
        }

        sendNetworkUpdate();
    }

    private boolean isRoomForOutput(ItemStack output) {
        ItemStack existingOutput = inv.func_70301_a(SLOT_OUTPUT);
        if (existingOutput == null) {
            return true;
        }
        if (StackHelper.canStacksMerge(output, existingOutput) && output.field_77994_a + existingOutput.field_77994_a <= output.func_77976_d()) {
            return true;
        }
        return false;
    }

    @Override
    public void writeData(ByteBuf buf) {
        buf.writeByte((byte) getMaxExpansionCount());
        NetworkUtils.writeStack(buf, clientOutputInv.func_70301_a(0));
    }

    @Override
    public void readData(ByteBuf buf) {
        maxExpCountClient = buf.readByte();
        clientOutputInv.func_70299_a(0, NetworkUtils.readStack(buf));
    }

    public int getMaxExpansionCount() {
        return field_145850_b.field_72995_K ? maxExpCountClient : (activeRecipe != null ? activeRecipe.getMaximumExpansionCount(func_70301_a(0)) : 0);
    }

    @Override
    public int getRequiredEnergy() {
        return hasWork() ? activeRecipe.getEnergyCost() : 0;
    }

    @Override
    public boolean canCraft() {
        return hasWork();
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == 0) {
            return true;
        } else if (activeRecipe == null) {
            return false;
        } else if (slot < 9) {
            int expansionCount = activeRecipe.getMaximumExpansionCount(func_70301_a(0));
            if (expansionCount > 0 && slot > expansionCount) {
                return false;
            }
            return activeRecipe.isValidExpansion(func_70301_a(0), stack);
        } else {
            return false;
        }
    }

    @Override
    public int func_70302_i_() {
        return 10;
    }

    @Override
    public String getInventoryName() {
        return BCStringUtils.localize("tile.integrationTableBlock.name");
    }

    @Override
    public boolean hasWork() {
        return activeRecipeValid;
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        super.func_70299_a(slot, stack);

        if (slot == 0) {
            updateRecipe();
        }
        if (slot < 9) {
            updateRecipeOutput();
        }
    }

    @Override
    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack result = super.func_70298_a(slot, amount);

        if (slot == 0) {
            updateRecipe();
        }
        if (slot < 9) {
            updateRecipeOutput();
        }

        return result;
    }

    @Override
    public void func_70296_d() {
        super.func_70296_d();
        updateRecipeOutput();
    }

    private void updateRecipe() {
        setNewActiveRecipe();
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return SLOTS;
    }

    @Override
    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        if (slot == 0) {
            return true;
        } else if (activeRecipe == null) {
            return false;
        } else if (slot < 9) {
            int expansionCount = activeRecipe.getMaximumExpansionCount(func_70301_a(0));
            if (expansionCount > 0 && slot > expansionCount) {
                return false;
            }
            return true;
        } else {
            return false;
        }
    }

    @Override
    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        return slot == 9;
    }
}
