/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.silicon;

import buildcraft.api.power.ILaserTarget;
import buildcraft.api.tiles.IControllable;
import buildcraft.api.tiles.IHasWork;
import buildcraft.core.lib.block.TileBuildCraft;
import buildcraft.core.lib.inventory.SimpleInventory;
import buildcraft.core.lib.inventory.StackHelper;
import buildcraft.core.lib.utils.AverageInt;
import buildcraft.core.lib.utils.Utils;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class TileLaserTableBase extends TileBuildCraft implements ILaserTarget, IInventory, IHasWork {
    public int clientRequiredEnergy = 0;
    protected SimpleInventory inv = new SimpleInventory(func_70302_i_(), "inv", 64);
    private int energy = 0;
    private int recentEnergyAverage;
    private AverageInt recentEnergyAverageUtil = new AverageInt(20);

    public TileLaserTableBase() {
        setControlMode(IControllable.Mode.On);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        recentEnergyAverageUtil.tick();
    }

    public int getEnergy() {
        return energy;
    }

    public void setEnergy(int energy) {
        this.energy = energy;
    }

    public void addEnergy(int energy) {
        this.energy += energy;
    }

    public void subtractEnergy(int energy) {
        this.energy -= energy;
    }

    public abstract int getRequiredEnergy();

    public int getProgressScaled(int ratio) {
        if (clientRequiredEnergy == 0) {
            return 0;
        } else if (energy >= clientRequiredEnergy) {
            return ratio;
        } else {
            return (int) ((double) energy / (double) clientRequiredEnergy * ratio);
        }
    }

    public int getRecentEnergyAverage() {
        return recentEnergyAverage;
    }

    public abstract boolean canCraft();

    /* @Override
    public boolean acceptsControlMode(Mode mode) {
        return mode == Mode.On || mode == Mode.Off;
    } */

    @Override
    public boolean requiresLaserEnergy() {
        return canCraft() && energy < getRequiredEnergy() * 5F /* && mode == Mode.On */;
    }

    @Override
    public void receiveLaserEnergy(int energy) {
        this.energy += energy;
        recentEnergyAverageUtil.push(energy);
    }

    @Override
    public boolean isInvalidTarget() {
        return func_145837_r();
    }

    @Override
    public ItemStack func_70301_a(int slot) {
        return inv.func_70301_a(slot);
    }

    @Override
    public ItemStack func_70298_a(int slot, int amount) {
        return inv.func_70298_a(slot, amount);
    }

    @Override
    public ItemStack func_70304_b(int slot) {
        return null;
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        inv.func_70299_a(slot, stack);
    }

    @Override
    public int func_70297_j_() {
        return inv.func_70297_j_();
    }

    @Override
    public boolean func_70300_a(EntityPlayer player) {
        return field_145850_b.func_175625_s(func_174877_v()) == this && !func_145837_r();
    }

    @Override
    public void func_174889_b(EntityPlayer player) {

    }

    @Override
    public void func_174886_c(EntityPlayer player) {

    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        inv.writeToNBT(nbt, "inv");
        nbt.func_74768_a("energy", energy);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        inv.readFromNBT(nbt, "inv");
        energy = nbt.func_74762_e("energy");
    }

    protected void outputStack(ItemStack remaining, boolean autoEject) {
        outputStack(remaining, null, 0, autoEject);
    }

    protected void outputStack(ItemStack remaining, IInventory inv, int slot, boolean autoEject) {
        if (autoEject) {
            if (remaining != null && remaining.field_77994_a > 0) {
                remaining.field_77994_a -= Utils.addToRandomInventoryAround(field_145850_b, func_174877_v(), remaining);
            }

            if (remaining != null && remaining.field_77994_a > 0) {
                remaining.field_77994_a -= Utils.addToRandomInjectableAround(field_145850_b, func_174877_v(), null, remaining);
            }
        }

        if (inv != null && remaining != null && remaining.field_77994_a > 0) {
            ItemStack inside = inv.func_70301_a(slot);

            if (inside == null || inside.field_77994_a <= 0) {
                inv.func_70299_a(slot, remaining);
                return;
            } else if (StackHelper.canStacksMerge(inside, remaining)) {
                remaining.field_77994_a -= StackHelper.mergeStacks(remaining, inside, true);
            }
        }

        if (remaining != null && remaining.field_77994_a > 0) {
            EntityItem entityitem = new EntityItem(field_145850_b, func_174877_v().func_177958_n() + 0.5, func_174877_v().func_177956_o() + 0.7, func_174877_v().func_177952_p() + 0.5, remaining);

            field_145850_b.func_72838_d(entityitem);
        }
    }

    public void getGUINetworkData(int id, int data) {
        int currentStored = energy;
        int requiredEnergy = clientRequiredEnergy;

        switch (id) {
            case 0:
                requiredEnergy = (requiredEnergy & 0xFFFF0000) | (data & 0xFFFF);
                clientRequiredEnergy = requiredEnergy;
                break;
            case 1:
                currentStored = (currentStored & 0xFFFF0000) | (data & 0xFFFF);
                energy = currentStored;
                break;
            case 2:
                requiredEnergy = (requiredEnergy & 0xFFFF) | ((data & 0xFFFF) << 16);
                clientRequiredEnergy = requiredEnergy;
                break;
            case 3:
                currentStored = (currentStored & 0xFFFF) | ((data & 0xFFFF) << 16);
                energy = currentStored;
                break;
            case 4:
                recentEnergyAverage = recentEnergyAverage & 0xFFFF0000 | (data & 0xFFFF);
                break;
            case 5:
                recentEnergyAverage = (recentEnergyAverage & 0xFFFF) | ((data & 0xFFFF) << 16);
                break;
        }
    }

    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        int requiredEnergy = getRequiredEnergy();
        int currentStored = energy;
        int lRecentEnergy = (int) (recentEnergyAverageUtil.getAverage() * 100f);
        iCrafting.func_71112_a(container, 0, requiredEnergy & 0xFFFF);
        iCrafting.func_71112_a(container, 1, currentStored & 0xFFFF);
        iCrafting.func_71112_a(container, 2, (requiredEnergy >>> 16) & 0xFFFF);
        iCrafting.func_71112_a(container, 3, (currentStored >>> 16) & 0xFFFF);
        iCrafting.func_71112_a(container, 4, lRecentEnergy & 0xFFFF);
        iCrafting.func_71112_a(container, 5, (lRecentEnergy >>> 16) & 0xFFFF);
    }
}
