/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.silicon;

import java.util.List;

import io.netty.buffer.ByteBuf;

import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

import net.minecraftforge.fml.relauncher.Side;

import buildcraft.api.recipes.BuildcraftRecipeRegistry;
import buildcraft.api.recipes.IProgrammingRecipe;
import buildcraft.BuildCraftCore;
import buildcraft.core.lib.network.command.CommandWriter;
import buildcraft.core.lib.network.command.ICommandReceiver;
import buildcraft.core.lib.network.command.PacketCommand;
import buildcraft.core.lib.utils.NetworkUtils;
import buildcraft.core.lib.utils.BCStringUtils;

public class TileProgrammingTable extends TileLaserTableBase implements IInventory, ISidedInventory, ICommandReceiver {
    public static final int WIDTH = 6;
    public static final int HEIGHT = 4;

    public String currentRecipeId = "";
    public IProgrammingRecipe currentRecipe;
    public List<ItemStack> options;
    public int optionId;
    private boolean queuedNetworkUpdate = false;

    private void queueNetworkUpdate() {
        queuedNetworkUpdate = true;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();

        if (field_145850_b.field_72995_K) {
            return;
        }

        if (queuedNetworkUpdate) {
            sendNetworkUpdate();
            queuedNetworkUpdate = false;
        }

        if (currentRecipe == null) {
            return;
        }

        if (this.func_70301_a(0) == null) {
            currentRecipe = null;
            return;
        }

        if (optionId >= 0 && getEnergy() >= currentRecipe.getEnergyCost(options.get(optionId))) {
            if (currentRecipe.canCraft(this.func_70301_a(0))) {
                ItemStack remaining = currentRecipe.craft(this.func_70301_a(0), options.get(optionId));
                if (remaining != null && remaining.field_77994_a > 0) {
                    setEnergy(0);
                    func_70298_a(0, remaining.field_77994_a);
                    outputStack(remaining, this, 1, false);
                }
            }
            findRecipe();
        }
    }

    /* IINVENTORY */
    @Override
    public int func_70302_i_() {
        return 2;
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        super.func_70299_a(slot, stack);

        if (slot == 0) {
            findRecipe();
        }
    }

    @Override
    public String getInventoryName() {
        return BCStringUtils.localize("tile.programmingTableBlock.name");
    }

    @Override
    public void readData(ByteBuf stream) {
        super.readData(stream);
        currentRecipeId = NetworkUtils.readUTF(stream);
        optionId = stream.readByte();
        updateRecipe();
    }

    @Override
    public void writeData(ByteBuf stream) {
        super.writeData(stream);
        NetworkUtils.writeUTF(stream, currentRecipeId);
        stream.writeByte(optionId);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);

        if (nbt.func_74764_b("recipeId") && nbt.func_74764_b("optionId")) {
            currentRecipeId = nbt.func_74779_i("recipeId");
            optionId = nbt.func_74762_e("optionId");
        } else {
            currentRecipeId = null;
        }
        updateRecipe();
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);

        if (currentRecipeId != null) {
            nbt.func_74778_a("recipeId", currentRecipeId);
            nbt.func_74774_a("optionId", (byte) optionId);
        }
    }

    @Override
    public int getRequiredEnergy() {
        if (hasWork()) {
            return currentRecipe.getEnergyCost(options.get(optionId));
        } else {
            return 0;
        }
    }

    public void findRecipe() {
        String oldId = currentRecipeId;
        currentRecipeId = null;

        if (func_70301_a(0) != null) {
            for (IProgrammingRecipe recipe : BuildcraftRecipeRegistry.programmingTable.getRecipes()) {
                if (recipe.canCraft(func_70301_a(0))) {
                    currentRecipeId = recipe.getId();
                    break;
                }
            }
        }

        if ((oldId != null && currentRecipeId != null && !oldId.equals(currentRecipeId)) || (oldId == null && currentRecipeId != null)
            || (oldId != null && currentRecipeId == null)) {
            optionId = -1;
            updateRecipe();
            queueNetworkUpdate();
        }
    }

    public void updateRecipe() {
        currentRecipe = BuildcraftRecipeRegistry.programmingTable.getRecipe(currentRecipeId);
        if (currentRecipe != null) {
            options = currentRecipe.getOptions(WIDTH, HEIGHT);
        } else {
            options = null;
        }
    }

    public void rpcSelectOption(final int pos) {
        BuildCraftCore.instance.sendToServer(new PacketCommand(this, "select", new CommandWriter() {
            @Override
            public void write(ByteBuf data) {
                data.writeByte(pos);
            }
        }));
    }

    @Override
    public void receiveCommand(String command, Side side, Object sender, ByteBuf stream) {
        if (side.isServer() && "select".equals(command)) {
            optionId = stream.readByte();
            if (optionId >= options.size()) {
                optionId = -1;
            } else if (optionId < -1) {
                optionId = -1;
            }

            queueNetworkUpdate();
        }
    }

    @Override
    public boolean hasWork() {
        return currentRecipe != null && optionId >= 0 && this.func_70301_a(1) == null;
    }

    @Override
    public boolean canCraft() {
        return hasWork();
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot == 0 || stack == null;
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return new int[] { 0, 1 };
    }

    @Override
    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        return slot == 0;
    }

    @Override
    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        return slot == 1;
    }
}
