/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.silicon.gui;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.Slot;

import buildcraft.core.lib.gui.BuildCraftContainer;
import buildcraft.core.lib.gui.slots.SlotOutput;
import buildcraft.core.lib.gui.slots.SlotPhantom;
import buildcraft.core.lib.gui.slots.SlotUntouchable;
import buildcraft.silicon.TileAdvancedCraftingTable;

public class ContainerAdvancedCraftingTable extends BuildCraftContainer {

    private TileAdvancedCraftingTable workbench;

    public ContainerAdvancedCraftingTable(EntityPlayer player, TileAdvancedCraftingTable table) {
        super(player, table.func_70302_i_());
        this.workbench = table;
        InventoryPlayer playerInventory = player.field_71071_by;

        for (int y = 0; y < 3; y++) {
            for (int x = 0; x < 3; x++) {
                func_75146_a(new SlotPhantom(table.getCraftingSlots(), x + y * 3, 33 + x * 18, 16 + y * 18));
            }
        }

        func_75146_a(new SlotUntouchable(table.getOutputSlot(), 0, 127, 34));

        for (int y = 0; y < 3; y++) {
            for (int x = 0; x < 5; x++) {
                func_75146_a(new Slot(workbench, x + y * 5, 15 + x * 18, 85 + y * 18));
            }
        }

        for (int y = 0; y < 3; y++) {
            for (int x = 0; x < 3; x++) {
                func_75146_a(new SlotOutput(workbench, 15 + x + y * 3, 109 + x * 18, 85 + y * 18));
            }
        }

        for (int l = 0; l < 3; l++) {
            for (int k1 = 0; k1 < 9; k1++) {
                func_75146_a(new Slot(playerInventory, k1 + l * 9 + 9, 8 + k1 * 18, 153 + l * 18));
            }

        }

        for (int i1 = 0; i1 < 9; i1++) {
            func_75146_a(new Slot(playerInventory, i1, 8 + i1 * 18, 211));
        }
    }

    @Override
    public boolean func_75145_c(EntityPlayer var1) {
        return workbench.func_70300_a(var1);
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();
        for (Object crafter : field_75149_d) {
            workbench.sendGUINetworkData(this, (ICrafting) crafter);
        }
    }

    @Override
    public void func_75137_b(int par1, int par2) {
        workbench.getGUINetworkData(par1, par2);
    }
}
