/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.silicon.gui;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;

import buildcraft.core.lib.gui.BuildCraftContainer;
import buildcraft.silicon.TileProgrammingTable;

public class ContainerProgrammingTable extends BuildCraftContainer {
    IInventory playerIInventory;
    TileProgrammingTable table;

    public ContainerProgrammingTable(EntityPlayer player, TileProgrammingTable table) {
        super(player, table.func_70302_i_());
        this.playerIInventory = player.field_71071_by;

        func_75146_a(new Slot(table, 0, 8, 36));
        func_75146_a(new Slot(table, 1, 8, 90));

        for (int l = 0; l < 3; l++) {
            for (int k1 = 0; k1 < 9; k1++) {
                func_75146_a(new Slot(player.field_71071_by, k1 + l * 9 + 9, 8 + k1 * 18, 123 + l * 18));
            }

        }

        for (int i1 = 0; i1 < 9; i1++) {
            func_75146_a(new Slot(player.field_71071_by, i1, 8 + i1 * 18, 181));
        }

        this.table = table;
    }

    @Override
    public boolean func_75145_c(EntityPlayer entityplayer) {
        return table.func_70300_a(entityplayer);
    }

    @Override
    public void func_75137_b(int i, int j) {
        table.getGUINetworkData(i, j);
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();

        for (Object crafter : field_75149_d) {
            table.sendGUINetworkData(this, (ICrafting) crafter);
        }
    }
}
