/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.silicon.gui;

import org.lwjgl.opengl.GL11;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;

import buildcraft.silicon.TileIntegrationTable;

public class GuiIntegrationTable extends GuiLaserTable {

    public static final ResourceLocation TEXTURE = new ResourceLocation("buildcraftsilicon:textures/gui/integration_table.png");
    private static final int FLASH_DELAY = 3;
    private final TileIntegrationTable integrationTable;
    private boolean flash;
    private int flashDelay;

    public GuiIntegrationTable(EntityPlayer player, TileIntegrationTable table) {
        super(player, new ContainerIntegrationTable(player, table), table, TEXTURE);
        this.integrationTable = table;
        field_146999_f = 176;
        field_147000_g = 186;
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();

        if (flashDelay <= 0) {
            flashDelay = FLASH_DELAY;
            flash = !flash;
        } else {
            flashDelay--;
        }
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        drawLedgers(par1, par2);

        String title = table.getInventoryName();
        field_146289_q.func_78276_b(title, getCenteredOffset(title), 6, 0x404040);
    }

    @Override
    protected void func_146976_a(float f, int mouseX, int mouseY) {
        super.func_146976_a(f, mouseX, mouseY);
        GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
        field_146297_k.field_71446_o.func_110577_a(TEXTURE);
        if (integrationTable.getEnergy() > 0) {
            int h = table.getProgressScaled(69);
            func_73729_b(field_147003_i + 164, field_147009_r + 18 + 74 - h, 176, 18, 4, h);
        }
        if (integrationTable.getMaxExpansionCount() > 0) {
            for (int i = 8; i > integrationTable.getMaxExpansionCount(); i--) {
                func_73729_b(field_147003_i + ContainerIntegrationTable.SLOT_X[i] - 1, field_147009_r + ContainerIntegrationTable.SLOT_Y[i] - 1, 180, 17,
                        18, 18);
            }
        }
    }
}
