/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.silicon.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;

import buildcraft.BuildCraftCore;
import buildcraft.core.client.CoreIconProvider;
import buildcraft.core.lib.gui.BuildCraftContainer;
import buildcraft.core.lib.gui.GuiBuildCraft;
import buildcraft.core.lib.gui.Ledger;
import buildcraft.core.lib.utils.BCStringUtils;
import buildcraft.silicon.TileLaserTableBase;

public abstract class GuiLaserTable extends GuiBuildCraft {

    private class LaserTableLedger extends Ledger {

        int headerColour = 0xe1c92f;
        int subheaderColour = 0xaaafb8;
        int textColour = 0x000000;

        public LaserTableLedger() {
            super(GuiLaserTable.this);
            maxHeight = 94;
            overlayColor = 0xd46c1f;
        }

        @Override
        public void draw(int x, int y) {

            // Draw background
            drawBackground(x, y);

            // Draw icon
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            drawIcon(CoreIconProvider.ENERGY.getSprite(), x + 3, y + 4);

            if (!isFullyOpened()) {
                return;
            }

            field_146289_q.func_175063_a(BCStringUtils.localize("gui.energy"), x + 22, y + 8, headerColour);
            field_146289_q.func_175063_a(BCStringUtils.localize("gui.assemblyCurrentRequired") + ":", x + 22, y + 20, subheaderColour);
            field_146289_q.func_78276_b(String.format("%d RF", table.clientRequiredEnergy), x + 22, y + 32, textColour);
            field_146289_q.func_175063_a(BCStringUtils.localize("gui.stored") + ":", x + 22, y + 44, subheaderColour);
            field_146289_q.func_78276_b(String.format("%d RF", table.getEnergy()), x + 22, y + 56, textColour);
            field_146289_q.func_175063_a(BCStringUtils.localize("gui.assemblyRate") + ":", x + 22, y + 68, subheaderColour);
            field_146289_q.func_78276_b(String.format("%.1f RF/t", table.getRecentEnergyAverage() / 100.0f), x + 22, y + 80, textColour);

        }

        @Override
        public String getTooltip() {
            return String.format("%.1f RF/t", table.getRecentEnergyAverage() / 100.0f);
        }
    }

    protected final TileLaserTableBase table;

    public GuiLaserTable(EntityPlayer player, BuildCraftContainer container, TileLaserTableBase table, ResourceLocation texture) {
        super(container, table, texture);
        this.table = table;
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        super.func_146979_b(par1, par2);
        String title = table.getInventoryName();
        field_146289_q.func_78276_b(title, getCenteredOffset(title), 6, 0x404040);
        field_146289_q.func_78276_b(BCStringUtils.localize("gui.inventory"), 8, field_147000_g - 97, 0x404040);
    }

    @Override
    protected void initLedgers(IInventory inventory) {
        super.initLedgers(inventory);
        if (!BuildCraftCore.hidePowerNumbers) {
            ledgerManager.add(new LaserTableLedger());
        }
    }
}
