package buildcraft.transport;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumFacing.AxisDirection;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

import buildcraft.api.transport.ICustomPipeConnection;
import buildcraft.core.lib.utils.Utils;

import net.minecraft.util.EnumFacing.AxisDirection;
public enum DefaultPipeConnection implements ICustomPipeConnection {
    INSTANCE;

    @Override
    public float getExtension(World world, BlockPos pos, EnumFacing face, IBlockState state) {
        Block block = state.func_177230_c();
        AxisAlignedBB bb = block.func_180640_a(world, pos, state);
        if (bb == null) {
            return 0;
        }
        // Invert the face (If it was up, we want to get the bottom of the block)
        if (face.func_176743_c() == AxisDirection.POSITIVE) {
            Vec3 min = Utils.min(bb).func_178788_d(Utils.convert(pos));
            return (float) Utils.getValue(min, face.func_176740_k());
        } else {
            Vec3 max = Utils.max(bb).func_178788_d(Utils.convert(pos));
            return 1 - (float) Utils.getValue(max, face.func_176740_k());
        }
    }
}
