package buildcraft.transport;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;

import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

import net.minecraftforge.fml.common.event.FMLInterModComms.IMCEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms.IMCMessage;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.BCLog;
import buildcraft.api.gates.GateExpansions;
import buildcraft.api.gates.IGateExpansion;
import buildcraft.core.IMCHandler;
import buildcraft.core.lib.utils.Utils;

public class IMCHandlerTransport extends IMCHandler {
    @Override
    public void processIMCEvent(IMCEvent event, IMCMessage m) {
        if (m.key.equals("add-facade")) {
            processAddFacadeIMC(event, m);
        } else if (m.key.equals("blacklist-facade")) {
            processBlacklistFacadeIMC(event, m);
        } else if (m.key.equals("add-gate-expansion-recipe")) {
            processGateExpansionRecipeAddIMC(event, m);
        }
    }

    public static void processGateExpansionRecipeAddIMC(IMCEvent event, IMCMessage msg) {
        boolean failed = false;
        if (!msg.isNBTMessage()) {
            failed = true;
        } else {
            NBTTagCompound recipe = msg.getNBTValue();
            if (!recipe.func_74764_b("id") || !recipe.func_74764_b("expansion") || !recipe.func_74764_b("input")) {
                failed = true;
            } else {
                IGateExpansion exp = GateExpansions.getExpansion(recipe.func_74779_i("expansion"));
                ItemStack is = ItemStack.func_77949_a(recipe.func_74775_l("input"));
                if (exp == null || is == null) {
                    failed = true;
                } else {
                    GateExpansions.registerExpansion(exp, is);
                }
            }
        }
        if (failed) {
            BCLog.logger.warn("Received invalid gate expansion recipe IMC message from mod %s!", msg.getSender());
        }
    }

    public static void processAddFacadeIMC(IMCEvent event, IMCMessage m) {
        try {
            if (m.isStringMessage()) {
                Splitter splitter = Splitter.on("@").trimResults();

                String[] array = Iterables.toArray(splitter.split(m.getStringValue()), String.class);
                if (array.length != 2) {
                    BCLog.logger.info(String.format("Received an invalid add-facade request %s from mod %s", m.getStringValue(), m.getSender()));
                } else {
                    String blockName = array[0];
                    Integer metaId = Ints.tryParse(array[1]);

                    if (Strings.isNullOrEmpty(blockName) || metaId == null) {
                        BCLog.logger.info(String.format("Received an invalid add-facade request %s from mod %s", m.getStringValue(), m.getSender()));
                    } else {
                        Block block = (Block) Block.field_149771_c.func_82594_a(new ResourceLocation(blockName));
                        BuildCraftTransport.facadeItem.addFacade(new ItemStack(block, 1, metaId));
                    }
                }
            } else if (m.isItemStackMessage()) {
                ItemStack modItemStack = m.getItemStackValue();
                BuildCraftTransport.facadeItem.addFacade(modItemStack);
            }
        } catch (Exception ex) {}
    }

    public static void processBlacklistFacadeIMC(IMCEvent event, IMCMessage message) {
        try {
            if (message.isItemStackMessage()) {
                ItemStack modItemStack = message.getItemStackValue();

                Block block = Block.func_149634_a(modItemStack.func_77973_b());
                if (block != null) {
                    String blockName = Utils.getNameForBlock(block);
                    ItemFacade.blacklistFacade(blockName);
                }
            } else {
                BCLog.logger.info(String.format("Invalid blacklist-facade message from mod %s. Send an ItemStackMessage instead.", message
                        .getSender()));
            }
        } catch (Throwable e) {}
    }
}
