/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.transport;

import java.util.List;

import org.apache.logging.log4j.Level;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.BCLog;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.transport.IItemPipe;
import buildcraft.core.BCCreativeTab;
import buildcraft.core.lib.items.ItemBuildCraft;
import buildcraft.core.lib.utils.BCStringUtils;
import buildcraft.core.lib.utils.ColorUtils;
import buildcraft.core.lib.utils.ModelHelper;

public class ItemPipe extends ItemBuildCraft implements IItemPipe {

    @SideOnly(Side.CLIENT)
    private IIconProvider iconProvider;
    private int pipeIconIndex;

    public ItemPipe(BCCreativeTab creativeTab) {
        super(creativeTab);
        this.func_77656_e(0);
        this.func_77627_a(true);
    }

    @Override
    public boolean func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float par8, float par9, float par10) {
        Block block = BuildCraftTransport.genericPipeBlock;

        Block worldBlock = world.func_180495_p(pos).func_177230_c();

        if (!worldBlock.func_176200_f(world, pos)) {
            pos = pos.func_177972_a(side);
        }

        if (stack.field_77994_a == 0) {
            return false;
        } else if (!player.func_175151_a(pos, side, stack)) {
            return false;
        } else if (world.func_175716_a(block, pos, false, side, null, stack)) {
            Pipe<?> pipe = BlockGenericPipe.createPipe(this);

            if (pipe == null) {
                BCLog.logger.log(Level.WARN, "Pipe failed to create during placement at {0}", pos);
                return true;
            }

            if (BlockGenericPipe.placePipe(pipe, world, pos, block.func_176223_P(), player, side)) {
                block.func_180633_a(world, pos, block.func_176223_P(), player, stack);

                if (!world.field_72995_K) {
                    TileEntity tile = world.func_175625_s(pos);
                    ((TileGenericPipe) tile).initializeFromItemMetadata(stack.func_77952_i());
                }

                world.func_72908_a(pos.func_177958_n() + 0.5F, pos.func_177956_o() + 0.5F, pos.func_177952_p() + 0.5F, block.field_149762_H.func_150496_b(), (block.field_149762_H
                        .func_150497_c() + 1.0F) / 2.0F, block.field_149762_H.func_150494_d() * 0.8F);

                stack.field_77994_a--;

                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    @SideOnly(Side.CLIENT)
    public void setPipesIcons(IIconProvider iconProvider) {
        this.iconProvider = iconProvider;
    }

    public void setPipeIconIndex(int index) {
        this.pipeIconIndex = index;
    }

    @SideOnly(Side.CLIENT)
    public TextureAtlasSprite getSprite() {
        if (iconProvider != null) { // invalid pipes won't have this set
            return iconProvider.getIcon(pipeIconIndex);
        } else {
            return null;
        }
    }

    @Override
    @SideOnly(Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean advanced) {
        super.func_77624_a(stack, player, list, advanced);
        if (stack.func_77952_i() >= 1) {
            int color = (stack.func_77952_i() - 1) & 15;
            list.add(ColorUtils.getFormattingTooltip(color) + EnumChatFormatting.ITALIC + BCStringUtils.localize("color." + ColorUtils.getName(
                    color)));
        }
        Class<? extends Pipe<?>> pipe = BlockGenericPipe.pipes.get(this);
        List<String> toolTip = PipeToolTipManager.getToolTip(pipe, advanced);
        list.addAll(toolTip);
    }

    @Override
    @SideOnly(Side.CLIENT)
    public int func_82790_a(ItemStack stack, int renderPass) {
        return renderPass;
    }

    @Override
    @SideOnly(Side.CLIENT)
    public void registerModels() {
        for (int i = 0; i < 17; i++) {
            ModelHelper.registerItemModel(this, i, "_" + i);
        }
    }
}
