/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.transport;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

import buildcraft.core.lib.block.TileBuildCraft;
import buildcraft.core.lib.inventory.SimpleInventory;

public class TileFilteredBuffer extends TileBuildCraft implements IInventory {

    private final SimpleInventory inventoryFilters = new SimpleInventory(9, "FilteredBufferFilters", 1);
    private final SimpleInventory inventoryStorage = new SimpleInventory(9, "FilteredBufferStorage", 64);

    @Override
    public void func_73660_a() {
        super.func_73660_a();
    }

    public IInventory getFilters() {
        return inventoryFilters;
    }

    /** IInventory Implementation **/

    @Override
    public int func_70302_i_() {
        return inventoryStorage.func_70302_i_();
    }

    @Override
    public ItemStack func_70301_a(int slotId) {
        return inventoryStorage.func_70301_a(slotId);
    }

    @Override
    public ItemStack func_70298_a(int slotId, int count) {
        return inventoryStorage.func_70298_a(slotId, count);
    }

    @Override
    public ItemStack func_70304_b(int slotId) {
        return inventoryStorage.func_70304_b(slotId);
    }

    @Override
    public void func_70299_a(int slotId, ItemStack itemStack) {
        inventoryStorage.func_70299_a(slotId, itemStack);
    }

    @Override
    public String getInventoryName() {
        return inventoryStorage.func_70005_c_();
    }

    @Override
    public int func_70297_j_() {
        return inventoryStorage.func_70297_j_();
    }

    @Override
    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return field_145850_b.func_175625_s(func_174877_v()) == this;
    }

    @Override
    public void func_174889_b(EntityPlayer player) {}

    @Override
    public void func_174886_c(EntityPlayer player) {}

    @Override
    public boolean func_94041_b(int i, ItemStack itemstack) {

        ItemStack filterItemStack = inventoryFilters.func_70301_a(i);

        if (filterItemStack == null || filterItemStack.func_77973_b() != itemstack.func_77973_b()) {
            return false;
        }

        if (itemstack.func_77973_b().func_77645_m()) {
            return true;
        }

        if (filterItemStack.func_77952_i() == itemstack.func_77952_i()) {
            return true;
        }

        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);

        NBTTagCompound inventoryStorageTag = nbtTagCompound;

        if (nbtTagCompound.func_74764_b("inventoryStorage")) {
            // To support pre 6.0 load
            inventoryStorageTag = (NBTTagCompound) nbtTagCompound.func_74781_a("inventoryStorage");
        }

        inventoryStorage.readFromNBT(inventoryStorageTag);

        NBTTagCompound inventoryFiltersTag = (NBTTagCompound) nbtTagCompound.func_74781_a("inventoryFilters");
        inventoryFilters.readFromNBT(inventoryFiltersTag);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTagCompound) {
        super.func_145841_b(nbtTagCompound);

        inventoryStorage.writeToNBT(nbtTagCompound);

        NBTTagCompound inventoryFiltersTag = new NBTTagCompound();
        inventoryFilters.writeToNBT(inventoryFiltersTag);
        nbtTagCompound.func_74782_a("inventoryFilters", inventoryFiltersTag);
    }
}
