package buildcraft.transport.api.impl;

import java.util.List;

import net.minecraft.block.Block;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import buildcraft.BuildCraftTransport;
import buildcraft.api.transport.IItemPipe;
import buildcraft.api.transport.pipe_bc8.PipeDefinition_BC8;
import buildcraft.core.lib.utils.BCStringUtils;
import buildcraft.core.lib.utils.ColorUtils;
import buildcraft.core.lib.utils.IModelRegister;
import buildcraft.core.lib.utils.ModelHelper;

public class ItemPipe extends Item implements IItemPipe, IModelRegister {
    private final PipeDefinition_BC8 defintion;

    public ItemPipe(PipeDefinition_BC8 definition) {
        func_77655_b("pipe_" + definition.modUniqueTag);
        this.defintion = definition;
    }

    @SideOnly(Side.CLIENT)
    public TextureAtlasSprite getSprite() {
        return defintion.getSprite(defintion.itemSpriteIndex);
    }

    @Override
    @SideOnly(Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean advanced) {
        super.func_77624_a(stack, player, list, advanced);
        if (stack.func_77952_i() >= 1) {
            int color = (stack.func_77952_i() - 1) & 15;
            list.add(ColorUtils.getFormattingTooltip(color) + EnumChatFormatting.ITALIC + BCStringUtils.localize("color." + ColorUtils.getName(
                    color)));
        }
        // Class<? extends Pipe> pipe = BlockGenericPipe.pipes.get(this);
        // List<String> toolTip = PipeToolTipManager.getToolTip(pipe, advanced);
        // list.addAll(toolTip);
    }

    @Override
    @SideOnly(Side.CLIENT)
    public int func_82790_a(ItemStack stack, int renderPass) {
        return renderPass;
    }

    @Override
    @SideOnly(Side.CLIENT)
    public void registerModels() {
        for (int i = 0; i < 17; i++) {
            ModelHelper.registerItemModel(this, i, "_" + i);
        }
    }

    // Copied from ItemBlock (mostly)
    @Override
    public boolean func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumFacing side, float hitX, float hitY,
            float hitZ) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();

        if (block == Blocks.field_150431_aC && ((Integer) iblockstate.func_177229_b(BlockSnow.field_176315_a)).intValue() < 1) {
            side = EnumFacing.UP;
        } else if (!block.func_176200_f(worldIn, pos)) {
            pos = pos.func_177972_a(side);
        }

        Block thisblock = BuildCraftTransport.pipeBlock;

        if (stack.field_77994_a == 0) {
            return false;
        } else if (!playerIn.func_175151_a(pos, side, stack)) {
            return false;
        } else if (pos.func_177956_o() == 255 && thisblock.func_149688_o().func_76220_a()) {
            return false;
        } else if (worldIn.func_175716_a(thisblock, pos, false, side, (Entity) null, stack)) {
            int i = this.func_77647_b(stack.func_77960_j());
            IBlockState iblockstate1 = thisblock.func_180642_a(worldIn, pos, side, hitX, hitY, hitZ, i, playerIn);

            if (placeBlockAt(stack, playerIn, worldIn, pos, side, hitX, hitY, hitZ, iblockstate1)) {
                worldIn.func_72908_a((double) ((float) pos.func_177958_n() + 0.5F), (double) ((float) pos.func_177956_o() + 0.5F), (double) ((float) pos.func_177952_p()
                    + 0.5F), thisblock.field_149762_H.func_150496_b(), (thisblock.field_149762_H.func_150497_c() + 1.0F) / 2.0F, thisblock.field_149762_H.func_150494_d()
                        * 0.8F);
                --stack.field_77994_a;
            }

            return true;
        } else {
            return false;
        }
    }

    // Also from item block
    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ,
            IBlockState newState) {
        if (!world.func_180501_a(pos, newState, 3)) return false;
        Block thisblock = BuildCraftTransport.pipeBlock;

        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == thisblock) {
            thisblock.func_180633_a(world, pos, state, player, stack);
        }

        return true;
    }
}
