package buildcraft.transport.block;

import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import buildcraft.core.lib.block.BlockBuildCraft;
import buildcraft.transport.pipes.bc8.TilePipe_BC8;

public class BlockPipe extends BlockBuildCraft {
    public BlockPipe() {
        super(Material.field_151592_s);
        func_149647_a(null);
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        super.func_180633_a(world, pos, state, entity, stack);
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        TilePipe_BC8 pipe = new TilePipe_BC8();
        pipe.func_145834_a(world);
        return pipe;
    }

    @Override
    public boolean func_149662_c() {
        return false;
    }

    @Override
    public boolean func_149686_d() {
        return false;
    }

    @Override
    @SideOnly(Side.CLIENT)
    public EnumWorldBlockLayer func_180664_k() {
        return EnumWorldBlockLayer.CUTOUT;
    }

    @Override
    public boolean canRenderInLayer(EnumWorldBlockLayer layer) {
        return layer == func_180664_k() || layer == EnumWorldBlockLayer.TRANSLUCENT;
    }

    @Override
    @SideOnly(Side.CLIENT)
    public int func_180662_a(IBlockAccess worldIn, BlockPos pos, int tintIndex) {
        // Just return the tinitIndex (It IS the colour needed- PipeBlockModel sorts that all out)
        return tintIndex;
    }
}
