/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.transport.gates;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;

import net.minecraftforge.common.util.Constants;

import buildcraft.api.gates.GateExpansionController;
import buildcraft.api.gates.GateExpansions;
import buildcraft.api.gates.IGateExpansion;
import buildcraft.transport.Gate;
import buildcraft.transport.Pipe;
import buildcraft.transport.gates.GateDefinition.GateLogic;
import buildcraft.transport.gates.GateDefinition.GateMaterial;

public final class GateFactory {

    /** Deactivate constructor */
    private GateFactory() {}

    public static Gate makeGate(Pipe<?> pipe, GateMaterial material, GateLogic logic, EnumFacing direction) {
        return new Gate(pipe, material, logic, direction);
    }

    public static Gate makeGate(Pipe<?> pipe, ItemStack stack, EnumFacing direction) {
        if (stack == null || stack.field_77994_a <= 0 || !(stack.func_77973_b() instanceof ItemGate)) {
            return null;
        }

        Gate gate = makeGate(pipe, ItemGate.getMaterial(stack), ItemGate.getLogic(stack), direction);

        for (IGateExpansion expansion : ItemGate.getInstalledExpansions(stack)) {
            gate.addGateExpansion(expansion);
        }

        return gate;
    }

    public static Gate makeGate(Pipe<?> pipe, NBTTagCompound nbt) {
        GateMaterial material = GateMaterial.REDSTONE;
        GateLogic logic = GateLogic.AND;
        EnumFacing direction = null;

        // Legacy Support
        if (nbt.func_74764_b("Kind")) {
            int kind = nbt.func_74762_e("Kind");
            switch (kind) {
                case 1:
                case 2:
                    material = GateMaterial.IRON;
                    break;
                case 3:
                case 4:
                    material = GateMaterial.GOLD;
                    break;
                case 5:
                case 6:
                    material = GateMaterial.DIAMOND;
                    break;
            }
            switch (kind) {
                case 2:
                case 4:
                case 6:
                    logic = GateLogic.OR;
                    break;
            }
        }

        if (nbt.func_74764_b("material")) {
            try {
                material = GateMaterial.valueOf(nbt.func_74779_i("material"));
            } catch (IllegalArgumentException ex) {
                return null;
            }
        }
        if (nbt.func_74764_b("logic")) {
            try {
                logic = GateLogic.valueOf(nbt.func_74779_i("logic"));
            } catch (IllegalArgumentException ex) {
                return null;
            }
        }
        if (nbt.func_74764_b("direction")) {
            direction = EnumFacing.func_82600_a(nbt.func_74762_e("direction"));
        }

        Gate gate = makeGate(pipe, material, logic, direction);
        gate.readFromNBT(nbt);

        // Legacy support
        if (nbt.func_74764_b("Pulser")) {
            NBTTagCompound pulsarTag = nbt.func_74775_l("Pulser");
            GateExpansionController pulsarCon = GateExpansionPulsar.INSTANCE.makeController(pipe.container);
            pulsarCon.readFromNBT(pulsarTag);
            gate.expansions.put(GateExpansionPulsar.INSTANCE, pulsarCon);
        }

        NBTTagList exList = nbt.func_150295_c("expansions", Constants.NBT.TAG_COMPOUND);
        for (int i = 0; i < exList.func_74745_c(); i++) {
            NBTTagCompound conNBT = exList.func_150305_b(i);
            IGateExpansion ex = GateExpansions.getExpansion(conNBT.func_74779_i("type"));
            if (ex != null) {
                GateExpansionController con = ex.makeController(pipe.container);
                con.readFromNBT(conNBT.func_74775_l("data"));
                gate.expansions.put(ex, con);
            }
        }

        return gate;
    }
}
