/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.transport.gui;

import org.lwjgl.opengl.GL11;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;

import buildcraft.BuildCraftCore;
import buildcraft.core.lib.gui.GuiBuildCraft;
import buildcraft.core.lib.utils.BCStringUtils;
import buildcraft.transport.IDiamondPipe;

public class GuiDiamondPipe extends GuiBuildCraft {

    private static final ResourceLocation TEXTURE;
    IInventory playerInventory;
    IInventory filterInventory;

    static {
        // FIXME: Make this listen to the property update in-game
        if (!BuildCraftCore.colorBlindMode) {
            TEXTURE = new ResourceLocation("buildcrafttransport:textures/gui/filter.png");
        } else {
            TEXTURE = new ResourceLocation("buildcrafttransport:textures/gui/filter_cb.png");
        }
    }

    public GuiDiamondPipe(EntityPlayer player, IDiamondPipe pipe) {
        super(new ContainerDiamondPipe(player, pipe), pipe.getFilters(), TEXTURE);
        this.playerInventory = player.field_71071_by;
        this.filterInventory = pipe.getFilters();
        field_146999_f = 175;
        field_147000_g = 225;
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        String string = filterInventory.func_145748_c_().func_150254_d();
        field_146289_q.func_78276_b(string, getCenteredOffset(string), 6, 0x404040);
        field_146289_q.func_78276_b(BCStringUtils.localize("gui.inventory"), 8, field_147000_g - 97, 0x404040);
    }

    @Override
    protected void func_146976_a(float f, int x, int y) {
        GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
        field_146297_k.field_71446_o.func_110577_a(TEXTURE);
        func_73729_b(field_147003_i, field_147009_r, 0, 0, field_146999_f, field_147000_g);
    }
}
