/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.transport.gui;

import org.lwjgl.opengl.GL11;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;

import buildcraft.core.lib.gui.GuiBuildCraft;
import buildcraft.core.lib.utils.BCStringUtils;
import buildcraft.transport.pipes.PipeFluidsEmerald;

public class GuiEmeraldFluidPipe extends GuiBuildCraft {

    private static final ResourceLocation TEXTURE = new ResourceLocation("buildcraftcore:textures/gui/generic_one_slot.png");
    IInventory playerInventory;
    IInventory filterInventory;

    public GuiEmeraldFluidPipe(EntityPlayer player, PipeFluidsEmerald pipe) {
        super(new ContainerEmeraldFluidPipe(player, pipe), pipe.getFilters(), TEXTURE);
        this.playerInventory = player.field_71071_by;
        this.filterInventory = pipe.getFilters();
        field_146999_f = 176;
        field_147000_g = 132;
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        String string = filterInventory.func_145748_c_().func_150254_d();
        field_146289_q.func_78276_b(string, getCenteredOffset(string), 6, 0x404040);
        field_146289_q.func_78276_b(BCStringUtils.localize("gui.inventory"), 8, field_147000_g - 97, 0x404040);
    }

    @Override
    protected void func_146976_a(float f, int x, int y) {
        GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
        field_146297_k.field_71446_o.func_110577_a(TEXTURE);
        func_73729_b(field_147003_i, field_147009_r, 0, 0, field_146999_f, field_147000_g);
    }
}
