/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.transport.gui;

import org.lwjgl.opengl.GL11;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;

import buildcraft.core.lib.gui.GuiBuildCraft;
import buildcraft.core.lib.gui.buttons.GuiImageButton;
import buildcraft.core.lib.gui.buttons.IButtonClickEventListener;
import buildcraft.core.lib.gui.buttons.IButtonClickEventTrigger;
import buildcraft.core.lib.gui.tooltips.ToolTip;
import buildcraft.core.lib.gui.tooltips.ToolTipLine;
import buildcraft.core.lib.network.PacketGuiReturn;
import buildcraft.core.lib.utils.BCStringUtils;
import buildcraft.transport.pipes.PipeItemsEmerald;
import buildcraft.transport.pipes.PipeItemsEmerald.FilterMode;

public class GuiEmeraldPipe extends GuiBuildCraft implements IButtonClickEventListener {

    private static final ResourceLocation TEXTURE = new ResourceLocation("buildcrafttransport:textures/gui/pipe_emerald.png");
    private static final ResourceLocation TEXTURE_BUTTON = new ResourceLocation("buildcrafttransport:textures/gui/pipe_emerald_button.png");
    private static final int WHITE_LIST_BUTTON_ID = 1;
    private static final int BLACK_LIST_BUTTON_ID = 2;
    private static final int ROUND_ROBIN_BUTTON_ID = 3;

    private GuiImageButton whiteListButton;
    private GuiImageButton blackListButton;
    private GuiImageButton roundRobinButton;

    private PipeItemsEmerald pipe;

    public GuiEmeraldPipe(EntityPlayer player, PipeItemsEmerald pipe) {
        super(new ContainerEmeraldPipe(player, pipe), pipe.getFilters(), TEXTURE);

        this.pipe = pipe;

        field_146999_f = 175;
        field_147000_g = 161;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();

        this.field_146292_n.clear();

        this.whiteListButton = new GuiImageButton(WHITE_LIST_BUTTON_ID, this.field_147003_i + 7, this.field_147009_r + 41, 18, TEXTURE_BUTTON, 19, 19);
        this.whiteListButton.registerListener(this);
        this.whiteListButton.setToolTip(new ToolTip(500, new ToolTipLine(StatCollector.func_74838_a("tip.PipeItemsEmerald.whitelist"))));
        this.field_146292_n.add(this.whiteListButton);

        this.blackListButton = new GuiImageButton(BLACK_LIST_BUTTON_ID, this.field_147003_i + 7 + 18, this.field_147009_r + 41, 18, TEXTURE_BUTTON, 37, 19);
        this.blackListButton.registerListener(this);
        this.blackListButton.setToolTip(new ToolTip(500, new ToolTipLine(StatCollector.func_74838_a("tip.PipeItemsEmerald.blacklist"))));
        this.field_146292_n.add(this.blackListButton);

        this.roundRobinButton = new GuiImageButton(ROUND_ROBIN_BUTTON_ID, this.field_147003_i + 7 + 36, this.field_147009_r + 41, 18, TEXTURE_BUTTON, 55, 19);
        this.roundRobinButton.registerListener(this);
        this.roundRobinButton.setToolTip(new ToolTip(500, new ToolTipLine(StatCollector.func_74838_a("tip.PipeItemsEmerald.roundrobin"))));
        this.field_146292_n.add(this.roundRobinButton);

        switch (pipe.getSettings().getFilterMode()) {
            case WHITE_LIST:
                this.whiteListButton.activate();
                break;
            case BLACK_LIST:
                this.blackListButton.activate();
                break;
            case ROUND_ROBIN:
                this.roundRobinButton.activate();
                break;
        }
    }

    @Override
    public void handleButtonClick(IButtonClickEventTrigger sender, int buttonId) {
        switch (buttonId) {
            case WHITE_LIST_BUTTON_ID:
                whiteListButton.activate();
                blackListButton.deActivate();
                roundRobinButton.deActivate();

                pipe.getSettings().setFilterMode(FilterMode.WHITE_LIST);
                break;
            case BLACK_LIST_BUTTON_ID:
                whiteListButton.deActivate();
                blackListButton.activate();
                roundRobinButton.deActivate();

                pipe.getSettings().setFilterMode(FilterMode.BLACK_LIST);
                break;
            case ROUND_ROBIN_BUTTON_ID:
                whiteListButton.deActivate();
                blackListButton.deActivate();
                roundRobinButton.activate();

                pipe.getSettings().setFilterMode(FilterMode.ROUND_ROBIN);
                break;
        }

        if (pipe.getWorld().field_72995_K) {
            PacketGuiReturn pkt = new PacketGuiReturn(pipe.getContainer());
            pkt.sendPacket();
        }
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        String title = BCStringUtils.localize("gui.pipes.emerald.title");

        field_146289_q.func_78276_b(title, (field_146999_f - field_146289_q.func_78256_a(title)) / 2, 6, 0x404040);
        field_146289_q.func_78276_b(BCStringUtils.localize("gui.inventory"), 8, field_147000_g - 93, 0x404040);
    }

    @Override
    protected void func_146976_a(float f, int x, int y) {
        GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
        field_146297_k.field_71446_o.func_110577_a(TEXTURE);
        func_73729_b(field_147003_i, field_147009_r, 0, 0, field_146999_f, field_147000_g);
    }
}
