/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.transport.gui;

import org.lwjgl.opengl.GL11;

import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;

import buildcraft.core.lib.utils.BCStringUtils;
import buildcraft.transport.TileFilteredBuffer;

public class GuiFilteredBuffer extends GuiContainer {

    private static final ResourceLocation TEXTURE = new ResourceLocation("buildcrafttransport:textures/gui/filteredBuffer_gui.png");
    IInventory playerInventory;
    TileFilteredBuffer filteredBuffer;

    public GuiFilteredBuffer(EntityPlayer player, TileFilteredBuffer filteredBuffer) {
        super(new ContainerFilteredBuffer(player, filteredBuffer));

        this.playerInventory = player.field_71071_by;
        this.filteredBuffer = filteredBuffer;
        field_146999_f = 175;
        field_147000_g = 169;
    }

    @Override
    protected void func_146976_a(float f, int x, int y) {
        GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);

        field_146297_k.field_71446_o.func_110577_a(TEXTURE);

        func_73729_b(field_147003_i, field_147009_r, 0, 0, field_146999_f, field_147000_g);

        IInventory filters = filteredBuffer.getFilters();

        for (int col = 0; col < filters.func_70302_i_(); col++) {
            if (filters.func_70301_a(col) == null) {
                func_73729_b(field_147003_i + 7 + col * 18, field_147009_r + 60, 176, 0, 18, 18);
            }
        }
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        String title = BCStringUtils.localize("tile.filteredBufferBlock.name");
        int xPos = (field_146999_f - field_146289_q.func_78256_a(title)) / 2;
        field_146289_q.func_78276_b(title, xPos, 10, 0x404040);
    }
}
