/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.transport.pipes;

import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.ISerializable;
import buildcraft.core.GuiIds;
import buildcraft.core.lib.inventory.SimpleInventory;
import buildcraft.core.lib.utils.FluidUtils;
import buildcraft.core.lib.utils.NetworkUtils;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.PipeIconProvider;

import io.netty.buffer.ByteBuf;

public class PipeFluidsEmerald extends PipeFluidsWood implements ISerializable {
    private SimpleInventory filters = new SimpleInventory(1, "Filters", 1);

    public PipeFluidsEmerald(Item item) {
        super(item);

        standardIconIndex = PipeIconProvider.TYPE.PipeFluidsEmerald_Standard.ordinal();
        solidIconIndex = PipeIconProvider.TYPE.PipeFluidsEmerald_Solid.ordinal();

        transport.initFromPipe(getClass());
    }

    public IInventory getFilters() {
        return filters;
    }

    @Override
    public int extractFluid(IFluidHandler fluidHandler, EnumFacing side) {
        FluidStack targetFluidStack = FluidUtils.getFluidStackFromItemStack(filters.func_70301_a(0));
        if (targetFluidStack == null) {
            return super.extractFluid(fluidHandler, side);
        }

        int flowRate = transport.getFlowRate();
        FluidStack toExtract = new FluidStack(targetFluidStack, fluidToExtract > flowRate ? flowRate : fluidToExtract);
        FluidStack extracted = fluidHandler.drain(side.func_176734_d(), toExtract, false);

        if (extracted != null) {
            toExtract.amount = transport.fill(side, extracted, true);
            if (toExtract.amount > 0) {
                fluidHandler.drain(side.func_176734_d(), toExtract, true);
            }
        }
        return toExtract.amount;
    }

    @Override
    public boolean blockActivated(EntityPlayer entityplayer, EnumFacing side) {
        if (entityplayer.func_71045_bC() != null) {
            if (Block.func_149634_a(entityplayer.func_71045_bC().func_77973_b()) instanceof BlockGenericPipe) {
                return false;
            }
        }

        if (super.blockActivated(entityplayer, side)) {
            return true;
        }

        if (!container.func_145831_w().field_72995_K) {
            entityplayer.openGui(BuildCraftTransport.instance, GuiIds.PIPE_EMERALD_FLUID, container.func_145831_w(), container.func_174877_v().func_177958_n(), container
                    .func_174877_v().func_177956_o(), container.func_174877_v().func_177952_p());
        }

        return true;
    }

    @Override
    public void writeData(ByteBuf data) {
        NBTTagCompound nbt = new NBTTagCompound();
        filters.writeToNBT(nbt);
        NetworkUtils.writeNBT(data, nbt);
    }

    @Override
    public void readData(ByteBuf data) {
        NBTTagCompound nbt = NetworkUtils.readNBT(data);
        filters.readFromNBT(nbt);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        filters.readFromNBT(nbt);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        filters.writeToNBT(nbt);
    }
}
