/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.transport.pipes;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

import buildcraft.api.core.EnumPipePart;
import buildcraft.api.properties.BuildCraftProperties;
import buildcraft.api.tools.IToolWrench;
import buildcraft.core.lib.TileBuffer;
import buildcraft.transport.Pipe;

public abstract class PipeLogicIron {

    protected final Pipe<?> pipe;
    private boolean lastPower = false;

    public PipeLogicIron(Pipe<?> pipe) {
        this.pipe = pipe;
    }

    public void switchOnRedstone() {
        boolean currentPower = pipe.container.func_145831_w().func_175687_A(pipe.container.func_174877_v()) > 0;

        if (currentPower != lastPower) {
            switchPosition();

            lastPower = currentPower;
        }
    }

    private void switchPosition() {
        int meta = pipe.container.func_145832_p();

        for (int i = meta + 1; i <= meta + 6; ++i) {
            EnumFacing facing = EnumFacing.func_82600_a(i % 6);
            if (setFacing(facing)) {
                return;
            }
        }
    }

    private boolean isValidFacing(EnumFacing side) {
        if (!pipe.container.isPipeConnected(side)) {
            return false;
        }

        if (side == null) {
            return true;
        }

        TileBuffer[] tileBuffer = pipe.container.getTileCache();

        if (tileBuffer == null) {
            return true;
        } else if (!tileBuffer[side.ordinal()].exists()) {
            return true;
        }

        TileEntity tile = tileBuffer[side.ordinal()].getTile();
        return isValidOutputTile(tile);
    }

    protected boolean isValidOutputTile(TileEntity tile) {
        return !(tile instanceof IInventory && ((IInventory) tile).func_70297_j_() == 0) && isValidConnectingTile(tile);
    }

    protected abstract boolean isValidConnectingTile(TileEntity tile);

    public void initialize() {
        lastPower = pipe.container.func_145831_w().func_175687_A(pipe.container.func_174877_v()) > 0;
    }

    public void onBlockPlaced() {
        setFacing(null);
        switchPosition();
    }

    public boolean setFacing(EnumFacing facing) {
        IBlockState state = pipe.container.func_145831_w().func_180495_p(pipe.container.func_174877_v());
        int ordinal = facing == null ? 6 : facing.ordinal();
        int oldOrdinal = state.func_177229_b(BuildCraftProperties.GENERIC_PIPE_DATA);

        if (ordinal != oldOrdinal && isValidFacing(facing)) {
            pipe.container.func_145831_w().func_175656_a(pipe.container.func_174877_v(), state.func_177226_a(BuildCraftProperties.GENERIC_PIPE_DATA, ordinal));
            pipe.container.scheduleRenderUpdate();
            return true;
        }
        return false;
    }

    public boolean blockActivated(EntityPlayer entityplayer, EnumPipePart side) {
        Item equipped = entityplayer.func_71045_bC() != null ? entityplayer.func_71045_bC().func_77973_b() : null;
        if (equipped instanceof IToolWrench && ((IToolWrench) equipped).canWrench(entityplayer, pipe.container.func_174877_v())) {
            if (side == EnumPipePart.CENTER || !pipe.getContainer().isPipeConnected(side.face)) {
                switchPosition();
            } else {
                setFacing(side.face);
            }
            pipe.container.scheduleRenderUpdate();
            ((IToolWrench) equipped).wrenchUsed(entityplayer, pipe.container.func_174877_v());

            return true;
        }

        return false;
    }

    public EnumFacing getOutputDirection() {
        return EnumFacing.func_82600_a(pipe.container.func_145832_p());
    }

    public boolean outputOpen(EnumFacing to) {
        return to.ordinal() == pipe.container.func_145832_p();
    }
}
