/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.transport.pipes;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

import buildcraft.api.core.EnumPipePart;
import buildcraft.api.tools.IToolWrench;
import buildcraft.core.lib.TileBuffer;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.Pipe;

public abstract class PipeLogicWood {

    protected final Pipe<?> pipe;

    public PipeLogicWood(Pipe<?> pipe) {
        this.pipe = pipe;
    }

    private void switchSource() {
        int meta = pipe.container.func_145832_p();
        EnumPipePart oldFacing = EnumPipePart.fromMeta(meta);
        EnumPipePart newFacing = oldFacing.next();
        if (oldFacing == EnumPipePart.CENTER) {
            oldFacing = oldFacing.next();
        }

        boolean first = true;
        while (oldFacing != newFacing || first) {
            first = false;
            if (setSource(newFacing)) {
                return;
            }
            newFacing = newFacing.next();
        }

        setSource(EnumPipePart.CENTER);
    }

    private boolean setSource(EnumPipePart newFacing) {
        if (newFacing == EnumPipePart.CENTER || isValidFacing(newFacing.face)) {
            int meta = pipe.container.func_145832_p();

            if (newFacing.ordinal() != meta) {
                IBlockState state = pipe.container.func_145831_w().func_180495_p(pipe.container.func_174877_v());
                state = state.func_177226_a(BlockGenericPipe.GENERIC_PIPE_DATA, newFacing.ordinal());
                pipe.container.func_145831_w().func_175656_a(pipe.container.func_174877_v(), state);
                pipe.container.scheduleRenderUpdate();
            }
            return true;
        }
        return false;
    }

    private void switchSourceIfNeeded() {
        int meta = pipe.container.func_145832_p();

        if (meta > 5) {
            switchSource();
        } else {
            EnumFacing facing = EnumFacing.func_82600_a(meta);
            if (!isValidFacing(facing)) {
                switchSource();
            }
        }
    }

    private boolean isValidFacing(EnumFacing side) {
        TileBuffer[] tileBuffer = pipe.container.getTileCache();
        if (tileBuffer == null) {
            return false;
        }

        if (!tileBuffer[side.ordinal()].exists()) {
            return false;
        }

        if (pipe.container.hasBlockingPluggable(side)) {
            return false;
        }

        TileEntity tile = tileBuffer[side.ordinal()].getTile();
        return isValidConnectingTile(tile);
    }

    protected abstract boolean isValidConnectingTile(TileEntity tile);

    public void initialize() {
        if (!pipe.container.func_145831_w().field_72995_K) {
            switchSourceIfNeeded();
        }
    }

    public boolean blockActivated(EntityPlayer entityplayer, EnumPipePart side) {
        Item equipped = entityplayer.func_71045_bC() != null ? entityplayer.func_71045_bC().func_77973_b() : null;
        if (equipped instanceof IToolWrench && ((IToolWrench) equipped).canWrench(entityplayer, pipe.container.func_174877_v())) {
            if (side != EnumPipePart.CENTER && pipe.getContainer().isPipeConnected(side.face)) {
                setSource(side);
            } else {
                switchSource();
            }
            ((IToolWrench) equipped).wrenchUsed(entityplayer, pipe.container.func_174877_v());
            return true;
        }

        return false;
    }

    public void onNeighborBlockChange() {
        if (!pipe.container.func_145831_w().field_72995_K) {
            switchSourceIfNeeded();
        }
    }
}
