package buildcraft.transport.pipes.bc8;

import net.minecraft.block.BlockStone;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;

import net.minecraftforge.oredict.OreDictionary;

public enum EnumPipeMaterial {
    // Extraction
    WOOD(2, new ItemStack(Blocks.field_150344_f, 1, OreDictionary.WILDCARD_VALUE)),
    /** Filtered extraction. */
    EMERALD(2, new ItemStack(Items.field_151166_bC)),
    // Variations of stone, don't connect to each other
    COBBLESTONE(1, new ItemStack(Blocks.field_150347_e)),
    STONE(1, new ItemStack(Blocks.field_150348_b)),
    ANDERSITE(1, new ItemStack(Blocks.field_150348_b, 1, BlockStone.EnumType.ANDESITE.func_176642_a())),
    ANDERSITE_POLISHED(1, new ItemStack(Blocks.field_150348_b, 1, BlockStone.EnumType.ANDESITE_SMOOTH.func_176642_a())),
    DIORITE(1, new ItemStack(Blocks.field_150348_b, 1, BlockStone.EnumType.DIORITE.func_176642_a())),
    DIORITE_POLISHED(1, new ItemStack(Blocks.field_150348_b, 1, BlockStone.EnumType.DIORITE_SMOOTH.func_176642_a())),
    GRANITE(1, new ItemStack(Blocks.field_150348_b, 1, BlockStone.EnumType.GRANITE.func_176642_a())),
    GRANITE_POLISHED(1, new ItemStack(Blocks.field_150348_b, 1, BlockStone.EnumType.GRANITE_SMOOTH.func_176642_a())),
    // Different functionality
    /** Send all contents only a single direction */
    IRON(2, new ItemStack(Items.field_151042_j)),
    /** Speed up contents */
    GOLD(1, new ItemStack(Items.field_151043_k)),
    /** Only connects to pipes */
    SANDSTONE(1, new ItemStack(Blocks.field_150322_A, 1, OreDictionary.WILDCARD_VALUE)),
    /** Insertion pipe, will prioritise insertion into an inventory rather than another pipe */
    CLAY(1, new ItemStack(Items.field_151119_aD)),
    /** Buffer pipe, will pause items if they cannot go directly into an inventory. (Like clay but doesn't put items
     * into a different place.) */
    QUARTZ(1, new ItemStack(Items.field_151128_bU)),
    /** Sorts contents based off filters for directions. */
    DIAMOND(7, new ItemStack(Items.field_151045_i)),
    /** Destroys contents */
    VOID(1, new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BLACK.func_176767_b()), new ItemStack(Items.field_151137_ax)),
    /** Sucks up items */
    OBSIDIAN(1, new ItemStack(Blocks.field_150343_Z)),
    /** Places items */
    STRIPES(1, new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BLACK.func_176767_b()), new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.YELLOW.func_176767_b()));

    public final int maxSprites;
    public final ItemStack ingredient1, ingredient2;

    EnumPipeMaterial(int maxSprites, ItemStack stack) {
        this(maxSprites, stack, stack);
    }

    EnumPipeMaterial(int maxSprites, ItemStack stack1, ItemStack stack2) {
        this.maxSprites = maxSprites;
        ingredient1 = stack1;
        ingredient2 = stack2;
    }

    public static final EnumPipeMaterial[][] STONES = { { COBBLESTONE, STONE }, { ANDERSITE, ANDERSITE_POLISHED }, { DIORITE, DIORITE_POLISHED }, {
        GRANITE, GRANITE_POLISHED } };
}
