package buildcraft.transport.pipes.bc8;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

import buildcraft.api.transport.pipe_bc8.IPipeHolder_BC8;
import buildcraft.api.transport.pipe_bc8.IPipe_BC8;
import buildcraft.api.transport.pipe_bc8.PipeAPI_BC8;
import buildcraft.api.transport.pipe_bc8.PipeDefinition_BC8;
import buildcraft.api.transport.pipe_bc8.event_bc8.IPipeEvent_BC8;
import buildcraft.core.lib.block.TileBuildCraft;
import buildcraft.transport.api.impl.event.PipeEvent_BC8;

public class TilePipe_BC8 extends TileBuildCraft implements IPipeHolder_BC8 {
    private Pipe_BC8 pipe;

    public TilePipe_BC8() {}

    @Override
    public void onBlockPlacedBy(EntityLivingBase entity, ItemStack stack) {
        super.onBlockPlacedBy(entity, stack);
        PipeDefinition_BC8 def = PipeAPI_BC8.PIPE_REGISTRY.getDefinition(stack.func_77973_b());
        pipe = new Pipe_BC8(this, def, func_145831_w());
    }

    @Override
    public IPipe_BC8 getPipe() {
        return pipe;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        String type = nbt.func_74779_i("type");
        PipeDefinition_BC8 definition = PipeAPI_BC8.PIPE_REGISTRY.getDefinition(type);
        pipe = new Pipe_BC8(this, definition, func_145831_w());
        pipe = pipe.readFromNBT(nbt.func_74781_a("pipe"));
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74778_a("type", PipeAPI_BC8.PIPE_REGISTRY.getTag(pipe.getBehaviour().definition));
        nbt.func_74782_a("pipe", pipe.writeToNBT());
    }

    @Override
    public void func_73660_a() {
        if (pipe.initialize()) return;
        IPipeEvent_BC8.Tick tick = func_145831_w().field_72995_K ? new PipeEvent_BC8.Tick.Client(pipe) : new PipeEvent_BC8.Tick.Server(pipe);
        pipe.fireEvent(tick);
    }
}
