/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.transport.schematics;

import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumFacing.Axis;

import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.SchematicTile;
import buildcraft.core.lib.inventory.SimpleInventory;

import net.minecraft.util.EnumFacing.Axis;
public class BptPipeFiltered extends BptPipeExtension {

    public BptPipeFiltered(Item i) {
        super(i);
    }

    @Override
    public void rotateLeft(SchematicTile slot, IBuilderContext context) {
        SimpleInventory inv = new SimpleInventory(54, "Filters", 1);
        SimpleInventory newInv = new SimpleInventory(54, "Filters", 1);
        inv.readFromNBT(slot.tileNBT);

        for (EnumFacing face : EnumFacing.field_82609_l) {
            int ordinalA = face.ordinal();
            int ordinalB = ordinalA;
            if (face.func_176740_k() != Axis.Y) {
                ordinalB = face.func_176746_e().ordinal();
            }

            for (int s = 0; s < 9; s++) {
                newInv.func_70299_a(ordinalB * 9 + s, inv.func_70301_a(ordinalA * 9 + s));
            }
        }

        newInv.writeToNBT(slot.tileNBT);
    }
}
