/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.transport.statements;

import java.util.Locale;

import buildcraft.api.core.EnumColor;
import buildcraft.api.statements.IActionInternal;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.core.lib.utils.BCStringUtils;
import buildcraft.core.statements.BCStatement;

public class ActionExtractionPreset extends BCStatement implements IActionInternal {

    public final EnumColor color;

    public ActionExtractionPreset(EnumColor color) {
        super("buildcraft:extraction.preset." + color.getTag(), "buildcraft.extraction.preset." + color.getTag());
        setBuildCraftLocation("transport", "triggers/extraction_preset_" + color.name().toLowerCase(Locale.ENGLISH));

        this.color = color;
    }

    @Override
    public String getDescription() {
        return String.format(BCStringUtils.localize("gate.action.extraction"), color.getName());
    }

    @Override
    public void actionActivate(IStatementContainer source, IStatementParameter[] parameters) {

    }
}
