package buildcraft.transport.stripes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.BCLog;
import buildcraft.api.transport.IStripesActivator;
import buildcraft.core.lib.utils.Utils;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.TravelingItem;
import buildcraft.transport.utils.TransportUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class PipeExtensionListener {
    private class PipeExtensionRequest {
        public ItemStack stack;
        public BlockPos pos;
        public EnumFacing o;
        public IStripesActivator h;
    }

    private final Map<Integer, HashSet<PipeExtensionRequest>> requests = new HashMap<>();

    public void requestPipeExtension(ItemStack stack, World world, BlockPos pos, EnumFacing o, IStripesActivator h) {
        if (world.field_72995_K) {
            return;
        }

        if (!requests.containsKey(world.field_73011_w.func_177502_q())) {
            requests.put(world.field_73011_w.func_177502_q(), new HashSet<PipeExtensionRequest>());
        }
        PipeExtensionRequest r = new PipeExtensionRequest();
        r.stack = stack;
        r.pos = pos;
        r.o = o;
        r.h = h;
        requests.get(world.field_73011_w.func_177502_q()).add(r);
    }

    @SubscribeEvent
    public void tick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END && requests.containsKey(event.world.field_73011_w.func_177502_q())) {
            HashSet<PipeExtensionRequest> rSet = requests.get(event.world.field_73011_w.func_177502_q());
            World w = event.world;
            for (PipeExtensionRequest r : rSet) {
                Vec3 target = Utils.convert(r.pos);

                boolean retract = r.stack.func_77973_b() == BuildCraftTransport.pipeItemsVoid;
                List<ItemStack> removedPipeStacks = null;

                if (retract) {
                    target = target.func_178787_e(Utils.convert(r.o, -1));
					if (w.func_180495_p(Utils.convertFloor(target)).func_177230_c() != BuildCraftTransport.genericPipeBlock) {
						r.h.sendItem(r.stack, r.o.func_176734_d());
						continue;
					}

					target = target.func_178787_e(Utils.convert(r.o, -1));
					if (w.func_180495_p(Utils.convertFloor(target)).func_177230_c() != BuildCraftTransport.genericPipeBlock) {
						r.h.sendItem(r.stack, r.o.func_176734_d());
						continue;
					}

					target = target.func_178787_e(Utils.convert(r.o, 1));
                } else {
                    target = target.func_178787_e(Utils.convert(r.o, 1));
                    if (!w.func_175623_d(Utils.convertFloor(target))) {
                        r.h.sendItem(r.stack, r.o.func_176734_d());
                        continue;
                    }
                }

                // Step 1: Copy over and remove existing pipe
                IBlockState oldState = w.func_180495_p(r.pos);
                NBTTagCompound nbt = new NBTTagCompound();
                TileEntity old = w.func_175625_s(r.pos);
                if (!(old instanceof TileGenericPipe)) {
                    BCLog.logger.warn("Found an invalid request at " + r.pos + " as " + old + " was not a tile generic pipe!");
                    continue;
                }
                old.func_145841_b(nbt);
                w.func_175698_g(r.pos);

                boolean failedPlacement = false;

                // Step 2: If retracting, remove previous pipe; if extending, add new pipe
                BlockPos targetPos = Utils.convertFloor(target);
                if (retract) {
                    removedPipeStacks = w.func_180495_p(targetPos).func_177230_c().getDrops(w, targetPos, w.func_180495_p(targetPos), 0);

                    w.func_175698_g(targetPos);
                } else {
                    r.stack.func_77973_b().func_180614_a(r.stack, CoreProxy.proxy.getBuildCraftPlayer((WorldServer) w, r.pos).get(), w, r.pos, EnumFacing.UP,
                            0, 0, 0);
                }

                // Step 3: Place stripes pipe back
                // - Correct NBT coordinates
                nbt.func_74768_a("x", MathHelper.func_76128_c(target.field_72450_a));
                nbt.func_74768_a("y", MathHelper.func_76128_c(target.field_72448_b));
                nbt.func_74768_a("z", MathHelper.func_76128_c(target.field_72449_c));
                // - Create block and tile
                w.func_180501_a(targetPos, oldState, 3);

                TileGenericPipe pipeTile = (TileGenericPipe) w.func_175625_s(targetPos);
                pipeTile.func_145839_a(nbt);

                pipeTile.func_145834_a(w);
                pipeTile.func_145829_t();
                pipeTile.func_73660_a();

                // Step 4: Hope for the best, clean up.
                PipeTransportItems items = (PipeTransportItems) ((Pipe) pipeTile.getPipe()).transport;
                if (!retract && !failedPlacement) {
                    r.stack.field_77994_a--;
                }

                if (r.stack.field_77994_a > 0) {
                    sendItem(items, r.stack, r.o.func_176734_d());
                }
                if (removedPipeStacks != null) {
                    for (ItemStack s : removedPipeStacks) {
                        sendItem(items, s, r.o.func_176734_d());
                    }
                }

                if (!retract && !failedPlacement) {
                    TileGenericPipe newPipeTile = (TileGenericPipe) w.func_175625_s(targetPos);
                    newPipeTile.func_73660_a();
                    pipeTile.scheduleNeighborChange();
                    if (pipeTile.getPipe() != null) {
                        ((Pipe) pipeTile.getPipe()).scheduleWireUpdate();
                    }
                }
            }
            rSet.clear();
        }
    }

    private void sendItem(PipeTransportItems transport, ItemStack itemStack, EnumFacing direction) {
        Vec3 pos = Utils.convert(transport.container.func_174877_v());
        pos = pos.func_72441_c(0.5, TransportUtils.getPipeFloorOf(itemStack), 0.5);
        TravelingItem newItem = TravelingItem.make(pos, itemStack);
        transport.injectItem(newItem, direction);
    }
}
