package buildcraft.transport.stripes;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

import buildcraft.api.transport.IStripesActivator;
import buildcraft.api.transport.IStripesHandler;

public class StripesHandlerArrow implements IStripesHandler {

    @Override
    public StripesHandlerType getType() {
        return StripesHandlerType.ITEM_USE;
    }

    @Override
    public boolean shouldHandle(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151032_g;
    }

    @Override
    public boolean handle(World world, BlockPos pos, EnumFacing direction, ItemStack stack, EntityPlayer player, IStripesActivator activator) {

        EntityArrow entityArrow = new EntityArrow(world, player, 0);

        entityArrow.func_70107_b(pos.func_177958_n() + 0.5d, pos.func_177956_o() + 0.5d, pos.func_177952_p() + 0.5d);
        entityArrow.func_70239_b(3);
        entityArrow.func_70240_a(1);
        entityArrow.field_70159_w = direction.func_82601_c() * 1.8d + world.field_73012_v.nextGaussian() * 0.007499999832361937D;
        entityArrow.field_70181_x = direction.func_96559_d() * 1.8d + world.field_73012_v.nextGaussian() * 0.007499999832361937D;
        entityArrow.field_70179_y = direction.func_82599_e() * 1.8d + world.field_73012_v.nextGaussian() * 0.007499999832361937D;
        world.func_72838_d(entityArrow);

        stack.field_77994_a--;
        if (stack.field_77994_a > 0) {
            activator.sendItem(stack, direction.func_176734_d());
        }

        return true;
    }

}
