package buildcraft.transport.stripes;

import java.util.List;

import com.google.common.collect.Lists;

import net.minecraft.block.BlockDispenser;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

import buildcraft.api.transport.IStripesActivator;
import buildcraft.api.transport.IStripesHandler;
import buildcraft.core.lib.utils.Utils;

public class StripesHandlerDispenser implements IStripesHandler {
    public static final List<Object> items = Lists.newArrayList();

    public class Source implements IBlockSource {
        private final World world;
        private final BlockPos pos;
        private final EnumFacing side;

        public Source(World world, BlockPos pos, EnumFacing side) {
            this.world = world;
            this.pos = pos;
            this.side = side;
        }

        @Override
        public double func_82615_a() {
            return (double) pos.func_177958_n() + 0.5D;
        }

        @Override
        public double func_82617_b() {
            return (double) pos.func_177956_o() + 0.5D;
        }

        @Override
        public double func_82616_c() {
            return (double) pos.func_177952_p() + 0.5D;
        }

        @Override
        public BlockPos func_180699_d() {
            return pos;
        }

        @Override
        public int func_82620_h() {
            return side.ordinal();
        }

        @Override
        public TileEntity func_150835_j() {
            return world.func_175625_s(pos);
        }

        @Override
        public World func_82618_k() {
            return world;
        }
    }

    @Override
    public StripesHandlerType getType() {
        return StripesHandlerType.ITEM_USE;
    }

    @Override
    public boolean shouldHandle(ItemStack stack) {
        if (items.contains(stack.func_77973_b())) {
            return true;
        }

        Class<?> c = stack.func_77973_b().getClass();
        while (c != Item.class) {
            if (items.contains(c)) {
                return true;
            }
            c = c.getSuperclass();
        }
        return false;
    }

    @Override
    public boolean handle(World world, BlockPos pos, EnumFacing direction, ItemStack stack, EntityPlayer player, IStripesActivator activator) {
        Vec3 origin = Utils.convert(pos).func_178787_e(Utils.convert(direction, -1));

        IBlockSource source = new Source(world, Utils.convertFloor(origin), direction);
        IBehaviorDispenseItem behaviour = (IBehaviorDispenseItem) BlockDispenser.field_149943_a.func_82594_a(stack.func_77973_b());
        if (behaviour != null) {
            ItemStack output = behaviour.func_82482_a(source, stack.func_77946_l());
            if (output.field_77994_a > 0) {
                activator.sendItem(output, direction.func_176734_d());
            }
            return true;
        }
        return false;
    }
}
