/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.transport.stripes;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

import buildcraft.api.transport.IStripesActivator;
import buildcraft.api.transport.IStripesHandler;

public class StripesHandlerEntityInteract implements IStripesHandler {

    @Override
    public StripesHandlerType getType() {
        return StripesHandlerType.ITEM_USE;
    }

    @Override
    public boolean shouldHandle(ItemStack stack) {
        return true;
    }

    @Override
    public boolean handle(World world, BlockPos pos, EnumFacing direction, ItemStack stack, EntityPlayer player, IStripesActivator activator) {

        AxisAlignedBB box = new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1));
        List<Entity> entities = world.func_72839_b(null, box);
        if (entities.size() <= 0) {
            return false;
        }

        List<EntityLivingBase> livingEntities = new LinkedList<>();
        for (Entity entityObj : entities) {
            if (entityObj instanceof EntityLivingBase) {
                livingEntities.add((EntityLivingBase) entityObj);
            }
        }

        player.func_70062_b(0, stack);

        boolean successful = false;
        Collections.shuffle(livingEntities);
        while (livingEntities.size() > 0) {
            EntityLivingBase entity = livingEntities.remove(0);

            if (!player.func_70998_m(entity)) {
                continue;
            }
            successful = true;
            dropItemsExcept(stack, player, activator, direction);
        }
        if (stack.field_77994_a > 0 && successful) {
            activator.sendItem(stack, direction.func_176734_d());
        }

        player.func_70062_b(0, null);

        return successful;
    }

    private void dropItemsExcept(ItemStack stack, EntityPlayer player, IStripesActivator activator, EnumFacing direction) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); i++) {
            ItemStack invStack = player.field_71071_by.func_70301_a(i);
            if (invStack != null && invStack != stack) {
                player.field_71071_by.func_70299_a(i, null);
                activator.sendItem(invStack, direction.func_176734_d());
            }
        }
    }

}
