package buildcraft.transport.stripes;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

import buildcraft.api.transport.IStripesActivator;
import buildcraft.api.transport.IStripesHandler;
import buildcraft.core.lib.utils.Utils;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.ItemPipeWire;

public class StripesHandlerPipeWires implements IStripesHandler {
    @Override
    public StripesHandlerType getType() {
        return StripesHandlerType.ITEM_USE;
    }

    @Override
    public boolean shouldHandle(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemPipeWire;
    }

    @Override
    public boolean handle(World world, BlockPos pos, EnumFacing direction, ItemStack stack, EntityPlayer player, IStripesActivator activator) {
        int pipesToTry = 8;
        int pipeWireColor = stack.func_77952_i();

        Vec3 p = Utils.convert(pos);

        while (pipesToTry > 0) {
            p = p.func_178787_e(Utils.convert(direction, -1));

            TileEntity tile = world.func_175625_s(Utils.convertFloor(p));
            if (tile instanceof TileGenericPipe) {
                TileGenericPipe pipeTile = (TileGenericPipe) tile;

                if (!pipeTile.pipe.wireSet[pipeWireColor]) {
                    pipeTile.pipe.wireSet[pipeWireColor] = true;
                    pipeTile.pipe.signalStrength[pipeWireColor] = 0;

                    pipeTile.pipe.updateSignalState();
                    pipeTile.scheduleRenderUpdate();
                    world.func_175685_c(pipeTile.func_174877_v(), pipeTile.getBlock());
                    return true;
                } else {
                    pipesToTry--;
                    continue;
                }
            } else {
                // Not a pipe, don't follow chain
                break;
            }
        }

        return false;
    }
}
