package buildcraft.transport.stripes;

import java.util.List;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

import net.minecraftforge.common.IShearable;

import buildcraft.api.transport.IStripesActivator;
import buildcraft.api.transport.IStripesHandler;

public class StripesHandlerShears implements IStripesHandler {

    @Override
    public StripesHandlerType getType() {
        return StripesHandlerType.ITEM_USE;
    }

    @Override
    public boolean shouldHandle(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemShears;
    }

    @Override
    public boolean handle(World world, BlockPos pos, EnumFacing direction, ItemStack stack, EntityPlayer player, IStripesActivator activator) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();

        if (block instanceof IShearable) {
            IShearable shearableBlock = (IShearable) block;
            if (shearableBlock.isShearable(stack, world, pos)) {
                world.func_72908_a(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), Block.field_149779_h.func_150495_a(), 1, 1);
                List<ItemStack> drops = shearableBlock.onSheared(stack, world, pos, EnchantmentHelper.func_77506_a(
                        Enchantment.field_77346_s.field_77352_x, stack));
                world.func_175698_g(pos);
                if (stack.func_96631_a(1, player.func_70681_au())) {
                    stack.field_77994_a--;
                }
                if (stack.field_77994_a > 0) {
                    activator.sendItem(stack, direction.func_176734_d());
                }
                for (ItemStack dropStack : drops) {
                    activator.sendItem(dropStack, direction.func_176734_d());
                }
                return true;
            }
        }

        return false;
    }

}
