/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory.tile;

import buildcraft.api.core.EnumPipePart;
import buildcraft.api.inventory.IItemTransactor;
import buildcraft.api.mj.MjAPI;
import buildcraft.api.mj.MjBattery;
import buildcraft.api.mj.MjCapabilityHelper;
import buildcraft.api.tiles.IDebuggable;
import buildcraft.factory.block.BlockChute;
import buildcraft.lib.block.BlockBCBase_Neptune;
import buildcraft.lib.inventory.ItemTransactorHelper;
import buildcraft.lib.inventory.NoSpaceTransactor;
import buildcraft.lib.inventory.TransactorEntityItem;
import buildcraft.lib.misc.BoundingBoxUtil;
import buildcraft.lib.mj.MjBatteryReceiver;
import buildcraft.lib.tile.TileBC_Neptune;
import buildcraft.lib.tile.item.ItemHandlerManager;
import buildcraft.lib.tile.item.ItemHandlerSimple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.apache.commons.lang3.tuple.Pair;

public class TileChute
extends TileBC_Neptune
implements ITickable,
IDebuggable {
    private static final int PICKUP_MAX = 3;
    public final ItemHandlerSimple inv;
    private final MjBattery battery;
    private int progress;

    public TileChute() {
        this.inv = this.itemManager.addInvHandler("inv", 4, ItemHandlerManager.EnumAccess.INSERT, EnumPipePart.VALUES);
        this.battery = new MjBattery(1L * MjAPI.MJ);
        this.progress = 0;
        this.caps.addProvider(new MjCapabilityHelper(new MjBatteryReceiver(this.battery)));
    }

    public static boolean hasInventoryAtPosition(IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity tile = world.func_175625_s(pos);
        return ItemTransactorHelper.getTransactor((ICapabilityProvider)tile, side.func_176734_d()) != NoSpaceTransactor.INSTANCE;
    }

    private void pickupItems(EnumFacing currentSide) {
        AxisAlignedBB aabb = BoundingBoxUtil.extrudeFace(this.func_174877_v(), currentSide, 0.25);
        int count = 3;
        for (EntityItem entity : this.field_145850_b.func_175647_a(EntityItem.class, aabb, EntitySelectors.field_94557_a)) {
            int moved;
            if ((count -= (moved = ItemTransactorHelper.move((IItemTransactor)new TransactorEntityItem(entity), (IItemTransactor)this.inv, count))) > 0) continue;
            return;
        }
    }

    private void putInNearInventories(EnumFacing currentSide) {
        ArrayList<EnumFacing> sides = new ArrayList<EnumFacing>(Arrays.asList(EnumFacing.field_82609_l));
        Collections.shuffle(sides, new Random());
        sides.removeIf(Predicate.isEqual(currentSide));
        Stream.concat(sides.stream().map(side -> Pair.of((Object)side, (Object)this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(side)))), sides.stream().flatMap(side -> this.field_145850_b.func_72872_a(Entity.class, new AxisAlignedBB(this.field_174879_c.func_177972_a(side))).stream().filter(entity -> !(entity instanceof EntityLivingBase)).map(entity -> Pair.of((Object)side, (Object)entity)))).map(sideProvider -> ItemTransactorHelper.getTransactor((ICapabilityProvider)sideProvider.getRight(), ((EnumFacing)sideProvider.getLeft()).func_176734_d())).filter(Predicate.isEqual(NoSpaceTransactor.INSTANCE).negate()).forEach(transactor -> ItemTransactorHelper.move((IItemTransactor)this.inv, transactor, 1));
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!(this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() instanceof BlockChute)) {
            return;
        }
        this.battery.tick(this.func_145831_w(), this.func_174877_v());
        EnumFacing currentSide = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(BlockBCBase_Neptune.BLOCK_FACING_6);
        int target = 100000;
        if (currentSide == EnumFacing.UP) {
            this.progress += 1000;
        }
        this.progress = (int)((long)this.progress + this.battery.extractPower(0L, target - this.progress));
        if (this.progress >= target) {
            this.progress = 0;
            this.pickupItems(currentSide);
        }
        this.putInNearInventories(currentSide);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.progress = nbt.func_74762_e("progress");
        this.battery.deserializeNBT(nbt.func_74775_l("battery"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("progress", this.progress);
        nbt.func_74782_a("battery", (NBTBase)this.battery.serializeNBT());
        return nbt;
    }

    @Override
    public void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        left.add("battery = " + this.battery.getDebugString());
        left.add("progress = " + this.progress);
    }
}

