/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide.parts;

import buildcraft.lib.client.guide.GuiGuide;
import buildcraft.lib.client.guide.PageLine;
import buildcraft.lib.client.guide.font.IFontRenderer;
import buildcraft.lib.client.guide.parts.GuidePart;
import buildcraft.lib.gui.ISimpleDrawable;
import buildcraft.lib.gui.pos.GuiRectangle;
import buildcraft.lib.misc.RenderUtil;

public abstract class GuideChapter
extends GuidePart {
    public static final int[] COLOURS = new int[]{10343872, 16433524, 2598109};
    public static final int MAX_HOWEVER_PROGRESS = 5;
    public static final int MAX_HOVER_DISTANCE = 20;
    public final PageLine chapter;
    private int hoverProgress = 0;
    private int hoverProgressLast = 0;
    protected EnumGuiSide lastDrawn = null;

    public GuideChapter(GuiGuide gui, String chapter) {
        this(gui, 0, chapter);
    }

    private int getColour() {
        int index = this.gui.getChapterIndex(this);
        if (index < 0) {
            index = this.chapter.text.hashCode();
            return index;
        }
        return COLOURS[index % COLOURS.length];
    }

    public GuideChapter(GuiGuide gui, int indent, String text) {
        super(gui);
        ISimpleDrawable icon = (x, y) -> {
            GuiGuide.BOX_EMPTY.drawAt(x, y);
            RenderUtil.setGLColorFromInt(this.getColour());
            GuiGuide.BOX_CHAPTER.drawAt(x, y);
            RenderUtil.setGLColorFromInt(-1);
        };
        ISimpleDrawable selected = (x, y) -> {
            GuiGuide.BOX_SELECTED_EMPTY.drawAt(x, y);
            RenderUtil.setGLColorFromInt(this.getColour());
            GuiGuide.BOX_SELECTED_CHAPTER.drawAt(x, y);
            RenderUtil.setGLColorFromInt(-1);
        };
        icon = null;
        selected = null;
        this.chapter = new PageLine(icon, selected, indent, text, false);
    }

    public void reset() {
        this.lastDrawn = EnumGuiSide.RIGHT;
    }

    @Override
    public GuidePart.PagePosition renderIntoArea(int x, int y, int width, int height, GuidePart.PagePosition current, int index) {
        current = current.guaranteeSpace(this.getFontRenderer().getMaxFontHeight() * 4, height);
        int colour = this.getColour();
        if (current.page == index) {
            RenderUtil.setGLColorFromInt(colour);
            int _x = x + 12;
            int _y = y + current.pixel;
            int _width = width - 24;
            GuiGuide.CHAPTER_MARKER_LEFT.drawAt(_x - 5, _y - 4);
            float oX = _x - 5 + GuiGuide.CHAPTER_MARKER_LEFT.width;
            GuiGuide.CHAPTER_MARKER_SPACE.drawScaledInside(oX, _y - 4, _width + 4, 16.0);
            GuiGuide.CHAPTER_MARKER_RIGHT.drawAt(_x + _width + 4, _y - 4);
            RenderUtil.setGLColorFromInt(-1);
        }
        GuidePart.PagePosition n = this.renderLine(current, this.chapter, x, y, width, height, index);
        if (n.page / 2 < (index /= 2)) {
            this.lastDrawn = EnumGuiSide.LEFT;
        } else if (index == current.page / 2 || index == current.page / 2) {
            this.lastDrawn = null;
        }
        return n;
    }

    @Override
    public GuidePart.PagePosition handleMouseClick(int x, int y, int width, int height, GuidePart.PagePosition current, int index, int mouseX, int mouseY) {
        current = current.guaranteeSpace(this.getFontRenderer().getMaxFontHeight() * 4, height);
        return this.renderLine(current, this.chapter, x, y, width, height, -1);
    }

    public EnumGuiSide draw(int index, float partialTicks) {
        IFontRenderer font = this.gui.getCurrentFont();
        String text = this.chapter.text;
        float hoverWidth = this.getHoverWidth(partialTicks);
        float width = (float)font.getStringWidth(text) + hoverWidth;
        int colour = COLOURS[index % COLOURS.length];
        int y = this.gui.minY + 20 * (index + 1);
        if (this.lastDrawn == EnumGuiSide.LEFT) {
            float x = (float)this.gui.minX - width - 4.0f + 11.0f;
            RenderUtil.setGLColorFromInt(colour);
            GuiGuide.CHAPTER_MARKER_LEFT.drawAt(x - 5.0f, y - 4);
            float oX = x - 5.0f + (float)GuiGuide.CHAPTER_MARKER_LEFT.width;
            GuiGuide.CHAPTER_MARKER_SPACE.drawScaledInside(oX, y - 4, width + 4.0f, 16.0);
            RenderUtil.setGLColorFromInt(-1);
            font.drawString(text, (int)x, y, 0);
        } else if (this.lastDrawn == EnumGuiSide.RIGHT) {
            int x = this.gui.minX + GuiGuide.PAGE_LEFT.width + GuiGuide.PAGE_RIGHT.width - 11;
            RenderUtil.setGLColorFromInt(colour);
            GuiGuide.CHAPTER_MARKER_SPACE.drawScaledInside(x, y - 4, width + 4.0f, 16.0);
            GuiGuide.CHAPTER_MARKER_RIGHT.drawAt((float)x + width + 4.0f, y - 4);
            RenderUtil.setGLColorFromInt(-1);
            font.drawString(text, (int)((float)(x + 4) + hoverWidth), y, 0);
        }
        return this.lastDrawn;
    }

    protected boolean isMouseInside() {
        int x;
        GuiRectangle drawRect;
        IFontRenderer font = this.gui.getCurrentFont();
        String text = this.chapter.text;
        int width = (int)((float)font.getStringWidth(text) + this.getHoverWidth(0.0f));
        int y = this.gui.minY + 20 * (this.gui.getChapterIndex(this) + 1);
        return this.lastDrawn == EnumGuiSide.LEFT ? (drawRect = new GuiRectangle(x = this.gui.minX - width - 4 + 11, y - 4, width + GuiGuide.CHAPTER_MARKER_LEFT.width, 16.0)).contains(this.gui.mouse) : this.lastDrawn == EnumGuiSide.RIGHT && (drawRect = new GuiRectangle(x = this.gui.minX + GuiGuide.PAGE_LEFT.width + GuiGuide.PAGE_RIGHT.width - 11, y - 4, width + GuiGuide.CHAPTER_MARKER_RIGHT.width, 16.0)).contains(this.gui.mouse);
    }

    private float getHoverWidth(float partialTicks) {
        float prog = partialTicks * (float)this.hoverProgress + (1.0f - partialTicks) * (float)this.hoverProgressLast;
        return prog * 20.0f / 5.0f;
    }

    public boolean handleClick() {
        if (this.isMouseInside()) {
            return this.onClick();
        }
        return false;
    }

    protected abstract boolean onClick();

    @Override
    public void updateScreen() {
        this.hoverProgressLast = this.hoverProgress++;
        if (this.isMouseInside()) {
            if (this.hoverProgress > 5) {
                this.hoverProgress = 5;
            }
        } else {
            --this.hoverProgress;
            if (this.hoverProgress < 0) {
                this.hoverProgress = 0;
            }
        }
    }

    public static enum EnumGuiSide {
        LEFT,
        RIGHT;

    }
}

