/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.tile;

import buildcraft.api.core.BCDebugging;
import buildcraft.api.core.BCLog;
import buildcraft.api.core.IPlayerOwned;
import buildcraft.lib.cache.CachedChunk;
import buildcraft.lib.cache.IChunkCache;
import buildcraft.lib.cache.ITileCache;
import buildcraft.lib.cache.TileCacheRet;
import buildcraft.lib.cache.TileCacheType;
import buildcraft.lib.cap.CapabilityHelper;
import buildcraft.lib.client.render.DetachedRenderer;
import buildcraft.lib.debug.BCAdvDebugging;
import buildcraft.lib.debug.IAdvDebugTarget;
import buildcraft.lib.delta.DeltaManager;
import buildcraft.lib.fluid.TankManager;
import buildcraft.lib.migrate.BCVersion;
import buildcraft.lib.misc.BlockUtil;
import buildcraft.lib.misc.ChunkUtil;
import buildcraft.lib.misc.FakePlayerProvider;
import buildcraft.lib.misc.InventoryUtil;
import buildcraft.lib.misc.MessageUtil;
import buildcraft.lib.misc.PermissionUtil;
import buildcraft.lib.misc.StringUtilBC;
import buildcraft.lib.misc.data.IdAllocator;
import buildcraft.lib.net.IPayloadReceiver;
import buildcraft.lib.net.IPayloadWriter;
import buildcraft.lib.net.MessageManager;
import buildcraft.lib.net.MessageUpdateTile;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.lib.tile.item.ItemHandlerManager;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;

public abstract class TileBC_Neptune
extends TileEntity
implements IPayloadReceiver,
IAdvDebugTarget,
IPlayerOwned {
    public static final boolean DEBUG = BCDebugging.shouldDebugLog("lib.tile");
    protected static final IdAllocator IDS = new IdAllocator("tile");
    public static final int NET_RENDER_DATA = IDS.allocId("RENDER_DATA");
    public static final int NET_GUI_DATA = IDS.allocId("GUI_DATA");
    public static final int NET_GUI_TICK = IDS.allocId("GUI_TICK");
    public static final int NET_REN_DELTA_SINGLE = IDS.allocId("REN_DELTA_SINGLE");
    public static final int NET_REN_DELTA_CLEAR = IDS.allocId("REN_DELTA_CLEAR");
    public static final int NET_GUI_DELTA_SINGLE = IDS.allocId("GUI_DELTA_SINGLE");
    public static final int NET_GUI_DELTA_CLEAR = IDS.allocId("GUI_DELTA_CLEAR");
    public static final int NET_ADV_DEBUG = IDS.allocId("DEBUG_DATA");
    public static final int NET_ADV_DEBUG_DISABLE = IDS.allocId("DEBUG_DISABLE");
    public static final int NET_REDRAW = IDS.allocId("REDRAW");
    protected final CapabilityHelper caps = new CapabilityHelper();
    protected final ItemHandlerManager itemManager = new ItemHandlerManager(this::onSlotChange);
    protected final TankManager tankManager = new TankManager();
    private final Set<EntityPlayer> usingPlayers = Sets.newIdentityHashSet();
    private GameProfile owner;
    private final IChunkCache chunkCache = new CachedChunk(this);
    private final ITileCache tileCache = TileCacheType.NEIGHBOUR_CACHE.create(this);
    protected final DeltaManager deltaManager = new DeltaManager((gui, type, writer) -> {
        int id;
        if (type == DeltaManager.EnumDeltaMessage.ADD_SINGLE) {
            id = gui ? NET_GUI_DELTA_SINGLE : NET_REN_DELTA_SINGLE;
        } else if (type == DeltaManager.EnumDeltaMessage.SET_VALUE) {
            id = gui ? NET_GUI_DELTA_CLEAR : NET_REN_DELTA_CLEAR;
        } else {
            throw new IllegalArgumentException("Unknown delta message type " + (Object)((Object)type));
        }
        if (gui) {
            this.createAndSendGuiMessage(id, writer);
        } else {
            this.createAndSendMessage(id, writer);
        }
    });

    public TileBC_Neptune() {
        this.caps.addProvider(this.itemManager);
    }

    public final IBlockState getCurrentState() {
        return BlockUtil.getBlockState(this.field_145850_b, this.field_174879_c);
    }

    @Nullable
    public final IBlockState getCurrentStateForBlock(Block expectedBlock) {
        IBlockState state = this.getCurrentState();
        if (state.func_177230_c() == expectedBlock) {
            return state;
        }
        return null;
    }

    public final IBlockState getNeighbourState(EnumFacing offset) {
        return this.getOffsetState(offset.func_176730_m());
    }

    public final IBlockState getOffsetState(Vec3i offset) {
        return this.getLocalState(this.field_174879_c.func_177971_a(offset));
    }

    public final IBlockState getLocalState(BlockPos pos) {
        if (DEBUG && !this.field_145850_b.func_175667_e(pos)) {
            BCLog.logger.warn("[lib.tile] Ghost-loading block at " + StringUtilBC.blockPosToString(pos) + " (from " + StringUtilBC.blockPosToString(this.func_174877_v()) + ")");
        }
        return BlockUtil.getBlockState(this.field_145850_b, pos, true);
    }

    public final TileEntity getNeighbourTile(EnumFacing offset) {
        TileCacheRet cached = this.tileCache.getTile(offset);
        if (cached != null) {
            return cached.tile;
        }
        if (DEBUG && !this.field_145850_b.func_175667_e(this.field_174879_c)) {
            BCLog.logger.warn("[lib.tile] Ghost-loading tile at " + StringUtilBC.blockPosToString(this.field_174879_c) + " (from " + StringUtilBC.blockPosToString(this.func_174877_v()) + ")");
        }
        return BlockUtil.getTileEntity(this.func_145831_w(), this.func_174877_v().func_177972_a(offset), true);
    }

    public final TileEntity getOffsetTile(Vec3i offset) {
        return this.getLocalTile(this.field_174879_c.func_177971_a(offset));
    }

    public final TileEntity getLocalTile(BlockPos pos) {
        TileCacheRet cached = this.tileCache.getTile(pos);
        if (cached != null) {
            return cached.tile;
        }
        if (DEBUG && !this.field_145850_b.func_175667_e(pos)) {
            BCLog.logger.warn("[lib.tile] Ghost-loading tile at " + StringUtilBC.blockPosToString(pos) + " (from " + StringUtilBC.blockPosToString(this.func_174877_v()) + ")");
        }
        return BlockUtil.getTileEntity(this.field_145850_b, pos, true);
    }

    public final Chunk getContainingChunk() {
        return this.chunkCache.getChunk(this.func_174877_v());
    }

    public final Chunk getChunk(BlockPos pos) {
        Chunk chunk = this.chunkCache.getChunk(pos);
        if (chunk == null) {
            return ChunkUtil.getChunk(this.func_145831_w(), pos, true);
        }
        return chunk;
    }

    public IdAllocator getIdAllocator() {
        return IDS;
    }

    public boolean cannotUpdate() {
        return !this.func_145830_o();
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public void onExplode(Explosion explosion) {
    }

    public void onRemove() {
        NonNullList toDrop = NonNullList.func_191196_a();
        this.addDrops((NonNullList<ItemStack>)toDrop, 0);
        InventoryUtil.dropAll(this.field_145850_b, this.field_174879_c, (NonNullList<ItemStack>)toDrop);
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.chunkCache.invalidate();
        this.tileCache.invalidate();
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.chunkCache.invalidate();
        this.tileCache.invalidate();
    }

    public void onLoad() {
        super.onLoad();
        this.chunkCache.invalidate();
        this.tileCache.invalidate();
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.chunkCache.invalidate();
        this.tileCache.invalidate();
    }

    public void addDrops(NonNullList<ItemStack> toDrop, int fortune) {
        this.itemManager.addDrops(toDrop);
        this.tankManager.addDrops(toDrop);
    }

    public void onPlacedBy(EntityLivingBase placer, ItemStack stack) {
        if (!placer.field_70170_p.field_72995_K) {
            if (placer instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)placer;
                this.owner = player.func_146103_bH();
                if (!this.owner.isComplete()) {
                    throw new IllegalArgumentException("Incomplete owner! ( " + placer + " -> " + this.owner + " )");
                }
            } else {
                throw new IllegalArgumentException("Not an EntityPlayer! (placer = " + placer + ")");
            }
        }
    }

    public void onPlayerOpen(EntityPlayer player) {
        if (this.owner == null) {
            this.owner = player.func_146103_bH();
            if (!this.owner.isComplete()) {
                throw new IllegalArgumentException("Incomplete owner! ( " + player + " -> " + this.owner + " )");
            }
        }
        this.sendNetworkUpdate(NET_GUI_DATA, player);
        this.usingPlayers.add(player);
    }

    public void onPlayerClose(EntityPlayer player) {
        this.usingPlayers.remove(player);
    }

    public boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return this.tankManager.onActivated(player, this.func_174877_v(), hand);
    }

    public void onNeighbourBlockChanged(Block block, BlockPos nehighbour) {
        this.tileCache.invalidate();
    }

    public final boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        return this.getCapability(capability, facing) != null;
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        Object obj = this.caps.getCapability(capability, facing);
        if (obj == null) {
            obj = super.getCapability(capability, facing);
        }
        return obj;
    }

    protected void onSlotChange(IItemHandlerModifiable handler, int slot, @Nonnull ItemStack before, @Nonnull ItemStack after) {
        if (this.field_145850_b.func_175667_e(this.field_174879_c)) {
            if (this.getCurrentState().func_185912_n()) {
                this.func_70296_d();
            } else {
                this.markChunkDirty();
            }
        }
    }

    public void markChunkDirty() {
        Chunk chunk;
        if (this.field_145850_b != null && (chunk = this.getContainingChunk()) != null) {
            chunk.func_76630_e();
        }
    }

    @Override
    public GameProfile getOwner() {
        if (this.owner == null) {
            String msg = "[lib.tile] Unknown owner for " + this.getClass() + " at ";
            BCLog.logger.warn(msg + StringUtilBC.blockPosToString(this.func_174877_v()));
            return FakePlayerProvider.NULL_PROFILE;
        }
        return this.owner;
    }

    public PermissionUtil.PermissionBlock getPermBlock() {
        return new PermissionUtil.PermissionBlock(this, this.field_174879_c);
    }

    public boolean canEditOther(BlockPos other) {
        return PermissionUtil.hasPermission(PermissionUtil.PERM_EDIT, this.getPermBlock(), PermissionUtil.createFrom(this.field_145850_b, other));
    }

    public boolean canPlayerEdit(EntityPlayer player) {
        return PermissionUtil.hasPermission(PermissionUtil.PERM_EDIT, player, this.getPermBlock());
    }

    public boolean canInteractWith(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        if (player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) > 64.0) {
            return false;
        }
        return this.canPlayerEdit(player);
    }

    public final void redrawBlock() {
        if (this.func_145830_o()) {
            if (this.field_145850_b.field_72995_K) {
                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 0);
                if (DEBUG) {
                    double x = (double)this.field_174879_c.func_177958_n() + 0.5;
                    double y = (double)this.field_174879_c.func_177956_o() + 0.5;
                    double z = (double)this.field_174879_c.func_177952_p() + 0.5;
                    this.field_145850_b.func_175688_a(EnumParticleTypes.HEART, x, y, z, 0.0, 0.0, 0.0, new int[0]);
                }
            } else {
                this.sendNetworkUpdate(NET_REDRAW);
            }
        }
    }

    public final void sendNetworkUpdate(int id) {
        if (this.func_145830_o()) {
            MessageUpdateTile message = this.createNetworkUpdate(id);
            if (this.field_145850_b.field_72995_K) {
                MessageManager.sendToServer(message);
            } else {
                MessageUtil.sendToAllWatching(this.field_145850_b, this.field_174879_c, message);
            }
        }
    }

    public final void sendNetworkGuiTick(EntityPlayer player) {
        if (this.func_145830_o() && !this.field_145850_b.field_72995_K) {
            MessageUpdateTile message = this.createNetworkUpdate(NET_GUI_TICK);
            if (message.getPayloadSize() <= 2) {
                return;
            }
            MessageManager.sendTo(message, (EntityPlayerMP)player);
        }
    }

    public final void sendNetworkGuiUpdate(int id) {
        if (this.func_145830_o()) {
            for (EntityPlayer player : this.usingPlayers) {
                this.sendNetworkUpdate(id, player);
            }
        }
    }

    public final void sendNetworkUpdate(int id, EntityPlayer target) {
        if (this.func_145830_o() && target instanceof EntityPlayerMP) {
            MessageUpdateTile message = this.createNetworkUpdate(id);
            MessageManager.sendTo(message, (EntityPlayerMP)target);
        }
    }

    public final MessageUpdateTile createNetworkUpdate(int id) {
        if (this.func_145830_o()) {
            Side side = this.field_145850_b.field_72995_K ? Side.CLIENT : Side.SERVER;
            return this.createMessage(id, buffer -> this.writePayload(id, buffer, side));
        }
        BCLog.logger.warn("Did not have a world at " + this.field_174879_c + "!");
        return null;
    }

    public final void createAndSendMessage(int id, IPayloadWriter writer) {
        if (this.func_145830_o()) {
            MessageUpdateTile message = this.createMessage(id, writer);
            if (this.field_145850_b.field_72995_K) {
                MessageManager.sendToServer(message);
            } else {
                MessageUtil.sendToAllWatching(this.field_145850_b, this.field_174879_c, message);
            }
        }
    }

    public final void createAndSendGuiMessage(int id, IPayloadWriter writer) {
        if (this.func_145830_o()) {
            MessageUpdateTile message = this.createMessage(id, writer);
            if (this.field_145850_b.field_72995_K) {
                MessageManager.sendToServer(message);
            } else {
                MessageUtil.sendToPlayers(this.usingPlayers, message);
            }
        }
    }

    public final void createAndSendMessage(int id, EntityPlayerMP player, IPayloadWriter writer) {
        if (this.func_145830_o()) {
            MessageUpdateTile message = this.createMessage(id, writer);
            MessageManager.sendTo(message, player);
        }
    }

    public final void createAndSendGuiMessage(int id, EntityPlayerMP player, IPayloadWriter writer) {
        if (this.usingPlayers.contains(player)) {
            this.createAndSendMessage(id, player, writer);
        }
    }

    public final MessageUpdateTile createMessage(int id, IPayloadWriter writer) {
        PacketBufferBC buffer = new PacketBufferBC(Unpooled.buffer());
        buffer.writeShort(id);
        writer.write(buffer);
        return new MessageUpdateTile(this.field_174879_c, buffer);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        ByteBuf buf = Unpooled.buffer();
        buf.writeShort(NET_RENDER_DATA);
        this.writePayload(NET_RENDER_DATA, new PacketBufferBC(buf), this.field_145850_b.field_72995_K ? Side.CLIENT : Side.SERVER);
        byte[] bytes = new byte[buf.readableBytes()];
        buf.readBytes(bytes);
        NBTTagCompound nbt = super.func_189517_E_();
        nbt.func_74773_a("d", bytes);
        return nbt;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.func_145839_a(tag);
        byte[] bytes = tag.func_74770_j("d");
        ByteBuf buf = Unpooled.copiedBuffer((byte[])bytes);
        try {
            int id = buf.readUnsignedShort();
            PacketBufferBC buffer = new PacketBufferBC(buf);
            this.readPayload(id, buffer, this.field_145850_b.field_72995_K ? Side.CLIENT : Side.SERVER, null);
            MessageUtil.ensureEmpty((ByteBuf)buffer, this.field_145850_b.field_72995_K, this.getClass() + ", id = " + this.getIdAllocator().getNameFor(id));
            this.spawnReceiveParticles(id);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void spawnReceiveParticles(int id) {
        if (DEBUG) {
            String name = this.getIdAllocator().getNameFor(id);
            if (this.field_145850_b != null) {
                double x = (double)this.field_174879_c.func_177958_n() + 0.5;
                double y = (double)this.field_174879_c.func_177956_o() + 0.5;
                double z = (double)this.field_174879_c.func_177952_p() + 0.5;
                double r = 0.01 + (double)(id & 3) / 4.0;
                double g = 0.01 + (double)(id / 4 & 3) / 4.0;
                double b = 0.01 + (double)(id / 16 & 3) / 4.0;
                this.field_145850_b.func_175688_a(EnumParticleTypes.REDSTONE, x, y, z, r, g, b, new int[0]);
            }
        }
    }

    @Override
    public final IMessage receivePayload(MessageContext ctx, PacketBufferBC buffer) throws IOException {
        int id = buffer.readUnsignedShort();
        this.readPayload(id, buffer, ctx.side, ctx);
        MessageUtil.ensureEmpty((ByteBuf)buffer, this.field_145850_b.field_72995_K, this.getClass() + ", id = " + this.getIdAllocator().getNameFor(id));
        if (ctx.side == Side.CLIENT) {
            this.spawnReceiveParticles(id);
        }
        return null;
    }

    public void writePayload(int id, PacketBufferBC buffer, Side side) {
        if (id == NET_GUI_DATA) {
            this.writePayload(NET_RENDER_DATA, buffer, side);
            if (side == Side.SERVER) {
                MessageUtil.writeGameProfile(buffer, this.owner);
            }
        }
        if (side == Side.SERVER) {
            if (id == NET_RENDER_DATA) {
                this.deltaManager.writeDeltaState(false, buffer);
            } else if (id == NET_GUI_DATA) {
                this.deltaManager.writeDeltaState(true, buffer);
            }
        }
    }

    public void readPayload(int id, PacketBufferBC buffer, Side side, MessageContext ctx) throws IOException {
        if (id == NET_GUI_DATA) {
            this.readPayload(NET_RENDER_DATA, buffer, side, ctx);
            if (side == Side.CLIENT) {
                this.owner = MessageUtil.readGameProfile(buffer);
            }
        }
        if (side == Side.CLIENT) {
            if (id == NET_RENDER_DATA) {
                this.deltaManager.receiveDeltaData(false, DeltaManager.EnumDeltaMessage.CURRENT_STATE, buffer);
            } else if (id == NET_GUI_DATA) {
                this.deltaManager.receiveDeltaData(true, DeltaManager.EnumDeltaMessage.CURRENT_STATE, buffer);
            } else if (id == NET_REN_DELTA_SINGLE) {
                this.deltaManager.receiveDeltaData(false, DeltaManager.EnumDeltaMessage.ADD_SINGLE, buffer);
            } else if (id == NET_GUI_DELTA_SINGLE) {
                this.deltaManager.receiveDeltaData(true, DeltaManager.EnumDeltaMessage.ADD_SINGLE, buffer);
            } else if (id == NET_REN_DELTA_CLEAR) {
                this.deltaManager.receiveDeltaData(false, DeltaManager.EnumDeltaMessage.SET_VALUE, buffer);
            } else if (id == NET_GUI_DELTA_CLEAR) {
                this.deltaManager.receiveDeltaData(true, DeltaManager.EnumDeltaMessage.SET_VALUE, buffer);
            } else if (id == NET_REDRAW) {
                this.redrawBlock();
            } else if (id == NET_ADV_DEBUG) {
                BCAdvDebugging.setClientDebugTarget(this);
            }
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.migrateOldNBT(nbt.func_74762_e("data-version"), nbt);
        this.deltaManager.readFromNBT(nbt.func_74775_l("deltas"));
        if (nbt.func_74764_b("owner")) {
            this.owner = NBTUtil.func_152459_a((NBTTagCompound)nbt.func_74775_l("owner"));
            if (this.owner == null || !this.owner.isComplete()) {
                String msg = "[lib.tile] Unknown owner (" + this.owner + ") for " + this.getClass() + " at ";
                BCLog.logger.warn(msg + this.func_174877_v() + " when reading from NBT");
            }
        } else {
            String msg = "[lib.tile] Unknown owner (null) for " + this.getClass() + " at ";
            BCLog.logger.warn(msg + this.func_174877_v() + " when reading from NBT");
        }
        if (nbt.func_150297_b("items", 10)) {
            this.itemManager.deserializeNBT(nbt.func_74775_l("items"));
        }
        if (nbt.func_150297_b("tanks", 10)) {
            this.tankManager.deserializeNBT(nbt.func_74775_l("tanks"));
        }
    }

    protected void migrateOldNBT(int version, NBTTagCompound nbt) {
        NBTTagCompound tankComp = nbt.func_74775_l("tank");
        if (!tankComp.func_82582_d()) {
            NBTTagCompound tanks = new NBTTagCompound();
            tanks.func_74782_a("tank", (NBTBase)tankComp);
            nbt.func_74782_a("tanks", (NBTBase)tanks);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        NBTTagCompound tanks;
        NBTTagCompound items;
        super.func_189515_b(nbt);
        nbt.func_74768_a("data-version", BCVersion.CURRENT.dataVersion);
        nbt.func_74782_a("deltas", (NBTBase)this.deltaManager.writeToNBT());
        if (this.owner != null && this.owner.isComplete()) {
            nbt.func_74782_a("owner", (NBTBase)NBTUtil.func_180708_a((NBTTagCompound)new NBTTagCompound(), (GameProfile)this.owner));
        }
        if (!(items = this.itemManager.serializeNBT()).func_82582_d()) {
            nbt.func_74782_a("items", (NBTBase)items);
        }
        if (!(tanks = this.tankManager.serializeNBT()).func_82582_d()) {
            nbt.func_74782_a("tanks", (NBTBase)tanks);
        }
        return nbt;
    }

    protected void func_190201_b(World world) {
        this.func_145834_a(world);
    }

    public boolean isBeingDebugged() {
        return BCAdvDebugging.isBeingDebugged(this);
    }

    public void enableDebugging() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        BCAdvDebugging.setCurrentDebugTarget(this);
    }

    @Override
    public void disableDebugging() {
        this.sendNetworkUpdate(NET_ADV_DEBUG_DISABLE);
    }

    @Override
    public boolean doesExistInWorld() {
        return this.func_145830_o() && this.field_145850_b.func_175625_s(this.field_174879_c) == this;
    }

    @Override
    public void sendDebugState() {
        this.sendNetworkUpdate(NET_ADV_DEBUG);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public DetachedRenderer.IDetachedRenderer getDebugRenderer() {
        return null;
    }
}

